@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.connectedvmwarevsphere.kotlin

import com.pulumi.azurenative.connectedvmwarevsphere.ResourcePoolArgs.builder
import com.pulumi.azurenative.connectedvmwarevsphere.kotlin.inputs.ExtendedLocationArgs
import com.pulumi.azurenative.connectedvmwarevsphere.kotlin.inputs.ExtendedLocationArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Define the resourcePool.
 * Azure REST API version: 2022-07-15-preview. Prior API version in Azure Native 1.x: 2020-10-01-preview.
 * Other available API versions: 2023-03-01-preview, 2023-10-01.
 * ## Example Usage
 * ### CreateResourcePool
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var resourcePool = new AzureNative.ConnectedVMwarevSphere.ResourcePool("resourcePool", new()
 *     {
 *         ExtendedLocation = new AzureNative.ConnectedVMwarevSphere.Inputs.ExtendedLocationArgs
 *         {
 *             Name = "/subscriptions/a5015e1c-867f-4533-8541-85cd470d0cfb/resourceGroups/demoRG/providers/Microsoft.ExtendedLocation/customLocations/contoso",
 *             Type = "customLocation",
 *         },
 *         Location = "East US",
 *         MoRefId = "aaaaaaa-bbbb-cccc-dddd-eeeeeeeeeeee",
 *         ResourceGroupName = "testrg",
 *         ResourcePoolName = "HRPool",
 *         VCenterId = "/subscriptions/fd3c3665-1729-4b7b-9a38-238e83b0f98b/resourceGroups/testrg/providers/Microsoft.ConnectedVMwarevSphere/VCenters/ContosoVCenter",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/connectedvmwarevsphere/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := connectedvmwarevsphere.NewResourcePool(ctx, "resourcePool", &connectedvmwarevsphere.ResourcePoolArgs{
 * 			ExtendedLocation: &connectedvmwarevsphere.ExtendedLocationArgs{
 * 				Name: pulumi.String("/subscriptions/a5015e1c-867f-4533-8541-85cd470d0cfb/resourceGroups/demoRG/providers/Microsoft.ExtendedLocation/customLocations/contoso"),
 * 				Type: pulumi.String("customLocation"),
 * 			},
 * 			Location:          pulumi.String("East US"),
 * 			MoRefId:           pulumi.String("aaaaaaa-bbbb-cccc-dddd-eeeeeeeeeeee"),
 * 			ResourceGroupName: pulumi.String("testrg"),
 * 			ResourcePoolName:  pulumi.String("HRPool"),
 * 			VCenterId:         pulumi.String("/subscriptions/fd3c3665-1729-4b7b-9a38-238e83b0f98b/resourceGroups/testrg/providers/Microsoft.ConnectedVMwarevSphere/VCenters/ContosoVCenter"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.connectedvmwarevsphere.ResourcePool;
 * import com.pulumi.azurenative.connectedvmwarevsphere.ResourcePoolArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var resourcePool = new ResourcePool("resourcePool", ResourcePoolArgs.builder()
 *             .extendedLocation(Map.ofEntries(
 *                 Map.entry("name", "/subscriptions/a5015e1c-867f-4533-8541-85cd470d0cfb/resourceGroups/demoRG/providers/Microsoft.ExtendedLocation/customLocations/contoso"),
 *                 Map.entry("type", "customLocation")
 *             ))
 *             .location("East US")
 *             .moRefId("aaaaaaa-bbbb-cccc-dddd-eeeeeeeeeeee")
 *             .resourceGroupName("testrg")
 *             .resourcePoolName("HRPool")
 *             .vCenterId("/subscriptions/fd3c3665-1729-4b7b-9a38-238e83b0f98b/resourceGroups/testrg/providers/Microsoft.ConnectedVMwarevSphere/VCenters/ContosoVCenter")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:connectedvmwarevsphere:ResourcePool HRPool /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ConnectedVMwarevSphere/resourcePools/{resourcePoolName}
 * ```
 * @property extendedLocation Gets or sets the extended location.
 * @property inventoryItemId Gets or sets the inventory Item ID for the resource pool.
 * @property kind Metadata used by portal/tooling/etc to render different UX experiences for resources of the same type; e.g. ApiApps are a kind of Microsoft.Web/sites type.  If supported, the resource provider must validate and persist this value.
 * @property location Gets or sets the location.
 * @property moRefId Gets or sets the vCenter MoRef (Managed Object Reference) ID for the resource pool.
 * @property resourceGroupName The Resource Group Name.
 * @property resourcePoolName Name of the resourcePool.
 * @property tags Gets or sets the Resource tags.
 * @property vCenterId Gets or sets the ARM Id of the vCenter resource in which this resource pool resides.
 */
public data class ResourcePoolArgs(
    public val extendedLocation: Output<ExtendedLocationArgs>? = null,
    public val inventoryItemId: Output<String>? = null,
    public val kind: Output<String>? = null,
    public val location: Output<String>? = null,
    public val moRefId: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val resourcePoolName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val vCenterId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.connectedvmwarevsphere.ResourcePoolArgs> {
    override fun toJava(): com.pulumi.azurenative.connectedvmwarevsphere.ResourcePoolArgs =
        com.pulumi.azurenative.connectedvmwarevsphere.ResourcePoolArgs.builder()
            .extendedLocation(extendedLocation?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .inventoryItemId(inventoryItemId?.applyValue({ args0 -> args0 }))
            .kind(kind?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .moRefId(moRefId?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .resourcePoolName(resourcePoolName?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .vCenterId(vCenterId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ResourcePoolArgs].
 */
@PulumiTagMarker
public class ResourcePoolArgsBuilder internal constructor() {
    private var extendedLocation: Output<ExtendedLocationArgs>? = null

    private var inventoryItemId: Output<String>? = null

    private var kind: Output<String>? = null

    private var location: Output<String>? = null

    private var moRefId: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var resourcePoolName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var vCenterId: Output<String>? = null

    /**
     * @param value Gets or sets the extended location.
     */
    @JvmName("yxruhlvmswvbjfps")
    public suspend fun extendedLocation(`value`: Output<ExtendedLocationArgs>) {
        this.extendedLocation = value
    }

    /**
     * @param value Gets or sets the inventory Item ID for the resource pool.
     */
    @JvmName("crwnrwokaxgtrjnd")
    public suspend fun inventoryItemId(`value`: Output<String>) {
        this.inventoryItemId = value
    }

    /**
     * @param value Metadata used by portal/tooling/etc to render different UX experiences for resources of the same type; e.g. ApiApps are a kind of Microsoft.Web/sites type.  If supported, the resource provider must validate and persist this value.
     */
    @JvmName("pveudhbldfjyxnqh")
    public suspend fun kind(`value`: Output<String>) {
        this.kind = value
    }

    /**
     * @param value Gets or sets the location.
     */
    @JvmName("peitlanoapnikypq")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value Gets or sets the vCenter MoRef (Managed Object Reference) ID for the resource pool.
     */
    @JvmName("lbdclxetlyhcjmqe")
    public suspend fun moRefId(`value`: Output<String>) {
        this.moRefId = value
    }

    /**
     * @param value The Resource Group Name.
     */
    @JvmName("trcmdpgdgqsufiff")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Name of the resourcePool.
     */
    @JvmName("hmhtfjugkvgwlmbu")
    public suspend fun resourcePoolName(`value`: Output<String>) {
        this.resourcePoolName = value
    }

    /**
     * @param value Gets or sets the Resource tags.
     */
    @JvmName("peostcssvljnuifv")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Gets or sets the ARM Id of the vCenter resource in which this resource pool resides.
     */
    @JvmName("xyislcijmvjhsgou")
    public suspend fun vCenterId(`value`: Output<String>) {
        this.vCenterId = value
    }

    /**
     * @param value Gets or sets the extended location.
     */
    @JvmName("uwksaxpxsiknrhyk")
    public suspend fun extendedLocation(`value`: ExtendedLocationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.extendedLocation = mapped
    }

    /**
     * @param argument Gets or sets the extended location.
     */
    @JvmName("ornasubfrtebkmxu")
    public suspend fun extendedLocation(argument: suspend ExtendedLocationArgsBuilder.() -> Unit) {
        val toBeMapped = ExtendedLocationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.extendedLocation = mapped
    }

    /**
     * @param value Gets or sets the inventory Item ID for the resource pool.
     */
    @JvmName("uccyglmvpytjbfaj")
    public suspend fun inventoryItemId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.inventoryItemId = mapped
    }

    /**
     * @param value Metadata used by portal/tooling/etc to render different UX experiences for resources of the same type; e.g. ApiApps are a kind of Microsoft.Web/sites type.  If supported, the resource provider must validate and persist this value.
     */
    @JvmName("smluqxblysyqqylg")
    public suspend fun kind(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kind = mapped
    }

    /**
     * @param value Gets or sets the location.
     */
    @JvmName("smtojjhqlkrrrred")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value Gets or sets the vCenter MoRef (Managed Object Reference) ID for the resource pool.
     */
    @JvmName("uoxulmebmqkknlxo")
    public suspend fun moRefId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.moRefId = mapped
    }

    /**
     * @param value The Resource Group Name.
     */
    @JvmName("wybqysjgfgxhsjop")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Name of the resourcePool.
     */
    @JvmName("bpopckvtutbvlrje")
    public suspend fun resourcePoolName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourcePoolName = mapped
    }

    /**
     * @param value Gets or sets the Resource tags.
     */
    @JvmName("vioaclklionnhhvf")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Gets or sets the Resource tags.
     */
    @JvmName("saoadyyaafjbnlbu")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value Gets or sets the ARM Id of the vCenter resource in which this resource pool resides.
     */
    @JvmName("dskvhrqpnsnitnjc")
    public suspend fun vCenterId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vCenterId = mapped
    }

    internal fun build(): ResourcePoolArgs = ResourcePoolArgs(
        extendedLocation = extendedLocation,
        inventoryItemId = inventoryItemId,
        kind = kind,
        location = location,
        moRefId = moRefId,
        resourceGroupName = resourceGroupName,
        resourcePoolName = resourcePoolName,
        tags = tags,
        vCenterId = vCenterId,
    )
}
