@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.connectedvmwarevsphere.kotlin.inputs

import com.pulumi.azurenative.connectedvmwarevsphere.inputs.OsProfileArgs.builder
import com.pulumi.azurenative.connectedvmwarevsphere.kotlin.enums.OsType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Specifies the operating system settings for the virtual machine.
 * @property adminPassword Gets or sets administrator password.
 * @property adminUsername Gets or sets administrator username.
 * @property computerName Gets or sets computer name.
 * @property guestId Gets or sets the guestId.
 * @property linuxConfiguration Specifies the linux configuration for update management.
 * @property osType Gets or sets the type of the os.
 * @property windowsConfiguration Specifies the windows configuration for update management.
 */
public data class OsProfileArgs(
    public val adminPassword: Output<String>? = null,
    public val adminUsername: Output<String>? = null,
    public val computerName: Output<String>? = null,
    public val guestId: Output<String>? = null,
    public val linuxConfiguration: Output<OsProfileLinuxConfigurationArgs>? = null,
    public val osType: Output<Either<String, OsType>>? = null,
    public val windowsConfiguration: Output<OsProfileWindowsConfigurationArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.connectedvmwarevsphere.inputs.OsProfileArgs> {
    override fun toJava(): com.pulumi.azurenative.connectedvmwarevsphere.inputs.OsProfileArgs =
        com.pulumi.azurenative.connectedvmwarevsphere.inputs.OsProfileArgs.builder()
            .adminPassword(adminPassword?.applyValue({ args0 -> args0 }))
            .adminUsername(adminUsername?.applyValue({ args0 -> args0 }))
            .computerName(computerName?.applyValue({ args0 -> args0 }))
            .guestId(guestId?.applyValue({ args0 -> args0 }))
            .linuxConfiguration(
                linuxConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .osType(
                osType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .windowsConfiguration(
                windowsConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [OsProfileArgs].
 */
@PulumiTagMarker
public class OsProfileArgsBuilder internal constructor() {
    private var adminPassword: Output<String>? = null

    private var adminUsername: Output<String>? = null

    private var computerName: Output<String>? = null

    private var guestId: Output<String>? = null

    private var linuxConfiguration: Output<OsProfileLinuxConfigurationArgs>? = null

    private var osType: Output<Either<String, OsType>>? = null

    private var windowsConfiguration: Output<OsProfileWindowsConfigurationArgs>? = null

    /**
     * @param value Gets or sets administrator password.
     */
    @JvmName("etcyrvdfbglkfnxq")
    public suspend fun adminPassword(`value`: Output<String>) {
        this.adminPassword = value
    }

    /**
     * @param value Gets or sets administrator username.
     */
    @JvmName("bxwlqqviecmnldnf")
    public suspend fun adminUsername(`value`: Output<String>) {
        this.adminUsername = value
    }

    /**
     * @param value Gets or sets computer name.
     */
    @JvmName("fruilysmyrjgtbhb")
    public suspend fun computerName(`value`: Output<String>) {
        this.computerName = value
    }

    /**
     * @param value Gets or sets the guestId.
     */
    @JvmName("xslpyiqaboltffoa")
    public suspend fun guestId(`value`: Output<String>) {
        this.guestId = value
    }

    /**
     * @param value Specifies the linux configuration for update management.
     */
    @JvmName("abnsiucinntfgakx")
    public suspend fun linuxConfiguration(`value`: Output<OsProfileLinuxConfigurationArgs>) {
        this.linuxConfiguration = value
    }

    /**
     * @param value Gets or sets the type of the os.
     */
    @JvmName("eccswijpykyukxgo")
    public suspend fun osType(`value`: Output<Either<String, OsType>>) {
        this.osType = value
    }

    /**
     * @param value Specifies the windows configuration for update management.
     */
    @JvmName("ubcmiddamycbgrsc")
    public suspend fun windowsConfiguration(`value`: Output<OsProfileWindowsConfigurationArgs>) {
        this.windowsConfiguration = value
    }

    /**
     * @param value Gets or sets administrator password.
     */
    @JvmName("uudkdddjtkxhrtcm")
    public suspend fun adminPassword(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.adminPassword = mapped
    }

    /**
     * @param value Gets or sets administrator username.
     */
    @JvmName("wvkfrbvdycwhstlj")
    public suspend fun adminUsername(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.adminUsername = mapped
    }

    /**
     * @param value Gets or sets computer name.
     */
    @JvmName("qoduqgiphexqcqmx")
    public suspend fun computerName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.computerName = mapped
    }

    /**
     * @param value Gets or sets the guestId.
     */
    @JvmName("jymslskjtvdqjnpm")
    public suspend fun guestId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.guestId = mapped
    }

    /**
     * @param value Specifies the linux configuration for update management.
     */
    @JvmName("cnsthvjfkumscmkj")
    public suspend fun linuxConfiguration(`value`: OsProfileLinuxConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.linuxConfiguration = mapped
    }

    /**
     * @param argument Specifies the linux configuration for update management.
     */
    @JvmName("vbonrujsavahgfqp")
    public suspend
    fun linuxConfiguration(argument: suspend OsProfileLinuxConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = OsProfileLinuxConfigurationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.linuxConfiguration = mapped
    }

    /**
     * @param value Gets or sets the type of the os.
     */
    @JvmName("vbkgpkbpdnujblcs")
    public suspend fun osType(`value`: Either<String, OsType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.osType = mapped
    }

    /**
     * @param value Gets or sets the type of the os.
     */
    @JvmName("romhigxtlfrpokai")
    public fun osType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, OsType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.osType = mapped
    }

    /**
     * @param value Gets or sets the type of the os.
     */
    @JvmName("cnkentuhrhriostw")
    public fun osType(`value`: OsType) {
        val toBeMapped = Either.ofRight<String, OsType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.osType = mapped
    }

    /**
     * @param value Specifies the windows configuration for update management.
     */
    @JvmName("bniuumetppeofuyn")
    public suspend fun windowsConfiguration(`value`: OsProfileWindowsConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.windowsConfiguration = mapped
    }

    /**
     * @param argument Specifies the windows configuration for update management.
     */
    @JvmName("xmbydmxemiqbuygl")
    public suspend
    fun windowsConfiguration(argument: suspend OsProfileWindowsConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = OsProfileWindowsConfigurationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.windowsConfiguration = mapped
    }

    internal fun build(): OsProfileArgs = OsProfileArgs(
        adminPassword = adminPassword,
        adminUsername = adminUsername,
        computerName = computerName,
        guestId = guestId,
        linuxConfiguration = linuxConfiguration,
        osType = osType,
        windowsConfiguration = windowsConfiguration,
    )
}
