@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.connectedvmwarevsphere.kotlin.inputs

import com.pulumi.azurenative.connectedvmwarevsphere.inputs.OsProfileLinuxConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Specifies the linux configuration for update management.
 * @property assessmentMode Specifies the assessment mode.
 * @property patchMode Specifies the patch mode.
 */
public data class OsProfileLinuxConfigurationArgs(
    public val assessmentMode: Output<String>? = null,
    public val patchMode: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.connectedvmwarevsphere.inputs.OsProfileLinuxConfigurationArgs> {
    override fun toJava():
        com.pulumi.azurenative.connectedvmwarevsphere.inputs.OsProfileLinuxConfigurationArgs =
        com.pulumi.azurenative.connectedvmwarevsphere.inputs.OsProfileLinuxConfigurationArgs.builder()
            .assessmentMode(assessmentMode?.applyValue({ args0 -> args0 }))
            .patchMode(patchMode?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [OsProfileLinuxConfigurationArgs].
 */
@PulumiTagMarker
public class OsProfileLinuxConfigurationArgsBuilder internal constructor() {
    private var assessmentMode: Output<String>? = null

    private var patchMode: Output<String>? = null

    /**
     * @param value Specifies the assessment mode.
     */
    @JvmName("trlaokdljvfhkhgv")
    public suspend fun assessmentMode(`value`: Output<String>) {
        this.assessmentMode = value
    }

    /**
     * @param value Specifies the patch mode.
     */
    @JvmName("mysdlscbcsauvmby")
    public suspend fun patchMode(`value`: Output<String>) {
        this.patchMode = value
    }

    /**
     * @param value Specifies the assessment mode.
     */
    @JvmName("umepoybjhadmwkob")
    public suspend fun assessmentMode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.assessmentMode = mapped
    }

    /**
     * @param value Specifies the patch mode.
     */
    @JvmName("guppouyxumnhsxbo")
    public suspend fun patchMode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.patchMode = mapped
    }

    internal fun build(): OsProfileLinuxConfigurationArgs = OsProfileLinuxConfigurationArgs(
        assessmentMode = assessmentMode,
        patchMode = patchMode,
    )
}
