@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.connectedvmwarevsphere.kotlin.inputs

import com.pulumi.azurenative.connectedvmwarevsphere.inputs.OsProfileWindowsConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Specifies the windows configuration for update management.
 * @property assessmentMode Specifies the assessment mode.
 * @property patchMode Specifies the patch mode.
 */
public data class OsProfileWindowsConfigurationArgs(
    public val assessmentMode: Output<String>? = null,
    public val patchMode: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.connectedvmwarevsphere.inputs.OsProfileWindowsConfigurationArgs> {
    override fun toJava():
        com.pulumi.azurenative.connectedvmwarevsphere.inputs.OsProfileWindowsConfigurationArgs =
        com.pulumi.azurenative.connectedvmwarevsphere.inputs.OsProfileWindowsConfigurationArgs.builder()
            .assessmentMode(assessmentMode?.applyValue({ args0 -> args0 }))
            .patchMode(patchMode?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [OsProfileWindowsConfigurationArgs].
 */
@PulumiTagMarker
public class OsProfileWindowsConfigurationArgsBuilder internal constructor() {
    private var assessmentMode: Output<String>? = null

    private var patchMode: Output<String>? = null

    /**
     * @param value Specifies the assessment mode.
     */
    @JvmName("xhgfvpywbjwbanuo")
    public suspend fun assessmentMode(`value`: Output<String>) {
        this.assessmentMode = value
    }

    /**
     * @param value Specifies the patch mode.
     */
    @JvmName("mkhdsvhlfwgdhwkn")
    public suspend fun patchMode(`value`: Output<String>) {
        this.patchMode = value
    }

    /**
     * @param value Specifies the assessment mode.
     */
    @JvmName("yiahkdxfmtkgrsoc")
    public suspend fun assessmentMode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.assessmentMode = mapped
    }

    /**
     * @param value Specifies the patch mode.
     */
    @JvmName("aitdcfvjmlmfajby")
    public suspend fun patchMode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.patchMode = mapped
    }

    internal fun build(): OsProfileWindowsConfigurationArgs = OsProfileWindowsConfigurationArgs(
        assessmentMode = assessmentMode,
        patchMode = patchMode,
    )
}
