@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.connectedvmwarevsphere.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Define the host.
 * @property customResourceName Gets the name of the corresponding resource in Kubernetes.
 * @property datastoreIds Gets or sets the datastore ARM ids.
 * @property extendedLocation Gets or sets the extended location.
 * @property id Gets or sets the Id.
 * @property inventoryItemId Gets or sets the inventory Item ID for the host.
 * @property kind Metadata used by portal/tooling/etc to render different UX experiences for resources of the same type; e.g. ApiApps are a kind of Microsoft.Web/sites type.  If supported, the resource provider must validate and persist this value.
 * @property location Gets or sets the location.
 * @property moName Gets or sets the vCenter Managed Object name for the host.
 * @property moRefId Gets or sets the vCenter MoRef (Managed Object Reference) ID for the host.
 * @property name Gets or sets the name.
 * @property networkIds Gets or sets the network ARM ids.
 * @property provisioningState Gets or sets the provisioning state.
 * @property statuses The resource status information.
 * @property systemData The system data.
 * @property tags Gets or sets the Resource tags.
 * @property type Gets or sets the type of the resource.
 * @property uuid Gets or sets a unique identifier for this resource.
 * @property vCenterId Gets or sets the ARM Id of the vCenter resource in which this host resides.
 */
public data class GetHostResult(
    public val customResourceName: String,
    public val datastoreIds: List<String>,
    public val extendedLocation: ExtendedLocationResponse? = null,
    public val id: String,
    public val inventoryItemId: String? = null,
    public val kind: String? = null,
    public val location: String,
    public val moName: String,
    public val moRefId: String? = null,
    public val name: String,
    public val networkIds: List<String>,
    public val provisioningState: String,
    public val statuses: List<ResourceStatusResponse>,
    public val systemData: SystemDataResponse,
    public val tags: Map<String, String>? = null,
    public val type: String,
    public val uuid: String,
    public val vCenterId: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.connectedvmwarevsphere.outputs.GetHostResult):
            GetHostResult = GetHostResult(
            customResourceName = javaType.customResourceName(),
            datastoreIds = javaType.datastoreIds().map({ args0 -> args0 }),
            extendedLocation = javaType.extendedLocation().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.connectedvmwarevsphere.kotlin.outputs.ExtendedLocationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            id = javaType.id(),
            inventoryItemId = javaType.inventoryItemId().map({ args0 -> args0 }).orElse(null),
            kind = javaType.kind().map({ args0 -> args0 }).orElse(null),
            location = javaType.location(),
            moName = javaType.moName(),
            moRefId = javaType.moRefId().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            networkIds = javaType.networkIds().map({ args0 -> args0 }),
            provisioningState = javaType.provisioningState(),
            statuses = javaType.statuses().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.connectedvmwarevsphere.kotlin.outputs.ResourceStatusResponse.Companion.toKotlin(args0)
                })
            }),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.connectedvmwarevsphere.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
            uuid = javaType.uuid(),
            vCenterId = javaType.vCenterId().map({ args0 -> args0 }).orElse(null),
        )
    }
}
