@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.connectedvmwarevsphere.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.Suppress

/**
 * Specifies the hardware settings for the virtual machine.
 * @property cpuHotAddEnabled Gets or sets a value indicating whether virtual processors can be added while this virtual machine is running.
 * @property cpuHotRemoveEnabled Gets or sets a value indicating whether virtual processors can be removed while this virtual machine is running.
 * @property memoryHotAddEnabled Gets or sets a value indicating whether memory can be added while this virtual machine is running.
 * @property memorySizeMB Gets or sets memory size in MBs for the vm.
 * @property numCPUs Gets or sets the number of vCPUs for the vm.
 * @property numCoresPerSocket Gets or sets the number of cores per socket for the vm. Defaults to 1 if unspecified.
 */
public data class HardwareProfileResponse(
    public val cpuHotAddEnabled: Boolean,
    public val cpuHotRemoveEnabled: Boolean,
    public val memoryHotAddEnabled: Boolean,
    public val memorySizeMB: Int? = null,
    public val numCPUs: Int? = null,
    public val numCoresPerSocket: Int? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.connectedvmwarevsphere.outputs.HardwareProfileResponse):
            HardwareProfileResponse = HardwareProfileResponse(
            cpuHotAddEnabled = javaType.cpuHotAddEnabled(),
            cpuHotRemoveEnabled = javaType.cpuHotRemoveEnabled(),
            memoryHotAddEnabled = javaType.memoryHotAddEnabled(),
            memorySizeMB = javaType.memorySizeMB().map({ args0 -> args0 }).orElse(null),
            numCPUs = javaType.numCPUs().map({ args0 -> args0 }).orElse(null),
            numCoresPerSocket = javaType.numCoresPerSocket().map({ args0 -> args0 }).orElse(null),
        )
    }
}
