@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.consumption.kotlin.inputs

import com.pulumi.azurenative.consumption.inputs.NotificationArgs.builder
import com.pulumi.azurenative.consumption.kotlin.enums.CultureCode
import com.pulumi.azurenative.consumption.kotlin.enums.OperatorType
import com.pulumi.azurenative.consumption.kotlin.enums.ThresholdType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * The notification associated with a budget.
 * @property contactEmails Email addresses to send the budget notification to when the threshold is exceeded. Must have at least one contact email or contact group specified at the Subscription or Resource Group scopes. All other scopes must have at least one contact email specified.
 * @property contactGroups Action groups to send the budget notification to when the threshold is exceeded. Must be provided as a fully qualified Azure resource id. Only supported at Subscription or Resource Group scopes.
 * @property contactRoles Contact roles to send the budget notification to when the threshold is exceeded.
 * @property enabled The notification is enabled or not.
 * @property locale Language in which the recipient will receive the notification
 * @property operator The comparison operator.
 * @property threshold Threshold value associated with a notification. Notification is sent when the cost exceeded the threshold. It is always percent and has to be between 0 and 1000.
 * @property thresholdType The type of threshold
 */
public data class NotificationArgs(
    public val contactEmails: Output<List<String>>,
    public val contactGroups: Output<List<String>>? = null,
    public val contactRoles: Output<List<String>>? = null,
    public val enabled: Output<Boolean>,
    public val locale: Output<Either<String, CultureCode>>? = null,
    public val `operator`: Output<Either<String, OperatorType>>,
    public val threshold: Output<Double>,
    public val thresholdType: Output<Either<String, ThresholdType>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.consumption.inputs.NotificationArgs> {
    override fun toJava(): com.pulumi.azurenative.consumption.inputs.NotificationArgs =
        com.pulumi.azurenative.consumption.inputs.NotificationArgs.builder()
            .contactEmails(contactEmails.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .contactGroups(contactGroups?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .contactRoles(contactRoles?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .enabled(enabled.applyValue({ args0 -> args0 }))
            .locale(
                locale?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .`operator`(
                `operator`.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .threshold(threshold.applyValue({ args0 -> args0 }))
            .thresholdType(
                thresholdType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [NotificationArgs].
 */
@PulumiTagMarker
public class NotificationArgsBuilder internal constructor() {
    private var contactEmails: Output<List<String>>? = null

    private var contactGroups: Output<List<String>>? = null

    private var contactRoles: Output<List<String>>? = null

    private var enabled: Output<Boolean>? = null

    private var locale: Output<Either<String, CultureCode>>? = null

    private var `operator`: Output<Either<String, OperatorType>>? = null

    private var threshold: Output<Double>? = null

    private var thresholdType: Output<Either<String, ThresholdType>>? = null

    /**
     * @param value Email addresses to send the budget notification to when the threshold is exceeded. Must have at least one contact email or contact group specified at the Subscription or Resource Group scopes. All other scopes must have at least one contact email specified.
     */
    @JvmName("wxqulefmfxknnswg")
    public suspend fun contactEmails(`value`: Output<List<String>>) {
        this.contactEmails = value
    }

    @JvmName("vosjlkeshajxvpqq")
    public suspend fun contactEmails(vararg values: Output<String>) {
        this.contactEmails = Output.all(values.asList())
    }

    /**
     * @param values Email addresses to send the budget notification to when the threshold is exceeded. Must have at least one contact email or contact group specified at the Subscription or Resource Group scopes. All other scopes must have at least one contact email specified.
     */
    @JvmName("bjkyurwnidupqyhy")
    public suspend fun contactEmails(values: List<Output<String>>) {
        this.contactEmails = Output.all(values)
    }

    /**
     * @param value Action groups to send the budget notification to when the threshold is exceeded. Must be provided as a fully qualified Azure resource id. Only supported at Subscription or Resource Group scopes.
     */
    @JvmName("ixloislmqxlttfxr")
    public suspend fun contactGroups(`value`: Output<List<String>>) {
        this.contactGroups = value
    }

    @JvmName("wlttldofakugolhj")
    public suspend fun contactGroups(vararg values: Output<String>) {
        this.contactGroups = Output.all(values.asList())
    }

    /**
     * @param values Action groups to send the budget notification to when the threshold is exceeded. Must be provided as a fully qualified Azure resource id. Only supported at Subscription or Resource Group scopes.
     */
    @JvmName("xptppfdcmtrkixdw")
    public suspend fun contactGroups(values: List<Output<String>>) {
        this.contactGroups = Output.all(values)
    }

    /**
     * @param value Contact roles to send the budget notification to when the threshold is exceeded.
     */
    @JvmName("csrsakdmusdnpbph")
    public suspend fun contactRoles(`value`: Output<List<String>>) {
        this.contactRoles = value
    }

    @JvmName("tkrrgrbhkilkkrpp")
    public suspend fun contactRoles(vararg values: Output<String>) {
        this.contactRoles = Output.all(values.asList())
    }

    /**
     * @param values Contact roles to send the budget notification to when the threshold is exceeded.
     */
    @JvmName("wjrhjcpqhntdasjr")
    public suspend fun contactRoles(values: List<Output<String>>) {
        this.contactRoles = Output.all(values)
    }

    /**
     * @param value The notification is enabled or not.
     */
    @JvmName("xvnipsefudpvnbuo")
    public suspend fun enabled(`value`: Output<Boolean>) {
        this.enabled = value
    }

    /**
     * @param value Language in which the recipient will receive the notification
     */
    @JvmName("decvljqqdxsvaayv")
    public suspend fun locale(`value`: Output<Either<String, CultureCode>>) {
        this.locale = value
    }

    /**
     * @param value The comparison operator.
     */
    @JvmName("fcwdkouxodpdqhbl")
    public suspend fun `operator`(`value`: Output<Either<String, OperatorType>>) {
        this.`operator` = value
    }

    /**
     * @param value Threshold value associated with a notification. Notification is sent when the cost exceeded the threshold. It is always percent and has to be between 0 and 1000.
     */
    @JvmName("hbblkhasggcbewum")
    public suspend fun threshold(`value`: Output<Double>) {
        this.threshold = value
    }

    /**
     * @param value The type of threshold
     */
    @JvmName("yanccgnciluulibi")
    public suspend fun thresholdType(`value`: Output<Either<String, ThresholdType>>) {
        this.thresholdType = value
    }

    /**
     * @param value Email addresses to send the budget notification to when the threshold is exceeded. Must have at least one contact email or contact group specified at the Subscription or Resource Group scopes. All other scopes must have at least one contact email specified.
     */
    @JvmName("erpdrqxvwsbwpabm")
    public suspend fun contactEmails(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.contactEmails = mapped
    }

    /**
     * @param values Email addresses to send the budget notification to when the threshold is exceeded. Must have at least one contact email or contact group specified at the Subscription or Resource Group scopes. All other scopes must have at least one contact email specified.
     */
    @JvmName("tqwlxiilqhigblio")
    public suspend fun contactEmails(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.contactEmails = mapped
    }

    /**
     * @param value Action groups to send the budget notification to when the threshold is exceeded. Must be provided as a fully qualified Azure resource id. Only supported at Subscription or Resource Group scopes.
     */
    @JvmName("puaddwqbjemugwac")
    public suspend fun contactGroups(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.contactGroups = mapped
    }

    /**
     * @param values Action groups to send the budget notification to when the threshold is exceeded. Must be provided as a fully qualified Azure resource id. Only supported at Subscription or Resource Group scopes.
     */
    @JvmName("nflsqejtjlxfhnug")
    public suspend fun contactGroups(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.contactGroups = mapped
    }

    /**
     * @param value Contact roles to send the budget notification to when the threshold is exceeded.
     */
    @JvmName("xoyxihsnvxglhwlk")
    public suspend fun contactRoles(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.contactRoles = mapped
    }

    /**
     * @param values Contact roles to send the budget notification to when the threshold is exceeded.
     */
    @JvmName("wtmlysyfjmiobndu")
    public suspend fun contactRoles(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.contactRoles = mapped
    }

    /**
     * @param value The notification is enabled or not.
     */
    @JvmName("qvdclkrbonfyymwo")
    public suspend fun enabled(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    /**
     * @param value Language in which the recipient will receive the notification
     */
    @JvmName("ahxxcsoxldmtlnwb")
    public suspend fun locale(`value`: Either<String, CultureCode>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.locale = mapped
    }

    /**
     * @param value Language in which the recipient will receive the notification
     */
    @JvmName("ttnbqbmletvkwpsh")
    public fun locale(`value`: String) {
        val toBeMapped = Either.ofLeft<String, CultureCode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.locale = mapped
    }

    /**
     * @param value Language in which the recipient will receive the notification
     */
    @JvmName("koyndouleibxvbwl")
    public fun locale(`value`: CultureCode) {
        val toBeMapped = Either.ofRight<String, CultureCode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.locale = mapped
    }

    /**
     * @param value The comparison operator.
     */
    @JvmName("yuaqnrhkacoahqws")
    public suspend fun `operator`(`value`: Either<String, OperatorType>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.`operator` = mapped
    }

    /**
     * @param value The comparison operator.
     */
    @JvmName("ugmwapwfjmduhjhu")
    public fun `operator`(`value`: String) {
        val toBeMapped = Either.ofLeft<String, OperatorType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.`operator` = mapped
    }

    /**
     * @param value The comparison operator.
     */
    @JvmName("aoxvxmaswtkbjmmj")
    public fun `operator`(`value`: OperatorType) {
        val toBeMapped = Either.ofRight<String, OperatorType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.`operator` = mapped
    }

    /**
     * @param value Threshold value associated with a notification. Notification is sent when the cost exceeded the threshold. It is always percent and has to be between 0 and 1000.
     */
    @JvmName("kooynjnhygartmvl")
    public suspend fun threshold(`value`: Double) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.threshold = mapped
    }

    /**
     * @param value The type of threshold
     */
    @JvmName("rawnfiylvstysdkp")
    public suspend fun thresholdType(`value`: Either<String, ThresholdType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.thresholdType = mapped
    }

    /**
     * @param value The type of threshold
     */
    @JvmName("kfjmxhnvashwtdbs")
    public fun thresholdType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ThresholdType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.thresholdType = mapped
    }

    /**
     * @param value The type of threshold
     */
    @JvmName("ruxhgutwmpujihch")
    public fun thresholdType(`value`: ThresholdType) {
        val toBeMapped = Either.ofRight<String, ThresholdType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.thresholdType = mapped
    }

    internal fun build(): NotificationArgs = NotificationArgs(
        contactEmails = contactEmails ?: throw PulumiNullFieldException("contactEmails"),
        contactGroups = contactGroups,
        contactRoles = contactRoles,
        enabled = enabled ?: throw PulumiNullFieldException("enabled"),
        locale = locale,
        `operator` = `operator` ?: throw PulumiNullFieldException("operator"),
        threshold = threshold ?: throw PulumiNullFieldException("threshold"),
        thresholdType = thresholdType,
    )
}
