@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.consumption.kotlin.outputs

import kotlin.Suppress

/**
 * The Dimensions or Tags to filter a budget by.
 * @property dimensions Has comparison expression for a dimension
 * @property tags Has comparison expression for a tag
 */
public data class BudgetFilterPropertiesResponse(
    public val dimensions: BudgetComparisonExpressionResponse? = null,
    public val tags: BudgetComparisonExpressionResponse? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.consumption.outputs.BudgetFilterPropertiesResponse):
            BudgetFilterPropertiesResponse = BudgetFilterPropertiesResponse(
            dimensions = javaType.dimensions().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.consumption.kotlin.outputs.BudgetComparisonExpressionResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            tags = javaType.tags().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.consumption.kotlin.outputs.BudgetComparisonExpressionResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
