@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerinstance.kotlin.inputs

import com.pulumi.azurenative.containerinstance.inputs.ContainerArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A container instance.
 * @property command The commands to execute within the container instance in exec form.
 * @property environmentVariables The environment variables to set in the container instance.
 * @property image The name of the image used to create the container instance.
 * @property livenessProbe The liveness probe.
 * @property name The user-provided name of the container instance.
 * @property ports The exposed ports on the container instance.
 * @property readinessProbe The readiness probe.
 * @property resources The resource requirements of the container instance.
 * @property securityContext The container security properties.
 * @property volumeMounts The volume mounts available to the container instance.
 */
public data class ContainerArgs(
    public val command: Output<List<String>>? = null,
    public val environmentVariables: Output<List<EnvironmentVariableArgs>>? = null,
    public val image: Output<String>,
    public val livenessProbe: Output<ContainerProbeArgs>? = null,
    public val name: Output<String>,
    public val ports: Output<List<ContainerPortArgs>>? = null,
    public val readinessProbe: Output<ContainerProbeArgs>? = null,
    public val resources: Output<ResourceRequirementsArgs>,
    public val securityContext: Output<SecurityContextDefinitionArgs>? = null,
    public val volumeMounts: Output<List<VolumeMountArgs>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.containerinstance.inputs.ContainerArgs> {
    override fun toJava(): com.pulumi.azurenative.containerinstance.inputs.ContainerArgs =
        com.pulumi.azurenative.containerinstance.inputs.ContainerArgs.builder()
            .command(command?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .environmentVariables(
                environmentVariables?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .image(image.applyValue({ args0 -> args0 }))
            .livenessProbe(livenessProbe?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .name(name.applyValue({ args0 -> args0 }))
            .ports(ports?.applyValue({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .readinessProbe(readinessProbe?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resources(resources.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .securityContext(securityContext?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .volumeMounts(
                volumeMounts?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [ContainerArgs].
 */
@PulumiTagMarker
public class ContainerArgsBuilder internal constructor() {
    private var command: Output<List<String>>? = null

    private var environmentVariables: Output<List<EnvironmentVariableArgs>>? = null

    private var image: Output<String>? = null

    private var livenessProbe: Output<ContainerProbeArgs>? = null

    private var name: Output<String>? = null

    private var ports: Output<List<ContainerPortArgs>>? = null

    private var readinessProbe: Output<ContainerProbeArgs>? = null

    private var resources: Output<ResourceRequirementsArgs>? = null

    private var securityContext: Output<SecurityContextDefinitionArgs>? = null

    private var volumeMounts: Output<List<VolumeMountArgs>>? = null

    /**
     * @param value The commands to execute within the container instance in exec form.
     */
    @JvmName("eqeybqiuluauujsw")
    public suspend fun command(`value`: Output<List<String>>) {
        this.command = value
    }

    @JvmName("djlwhfetysixpugx")
    public suspend fun command(vararg values: Output<String>) {
        this.command = Output.all(values.asList())
    }

    /**
     * @param values The commands to execute within the container instance in exec form.
     */
    @JvmName("bxxjkxetpbahuipq")
    public suspend fun command(values: List<Output<String>>) {
        this.command = Output.all(values)
    }

    /**
     * @param value The environment variables to set in the container instance.
     */
    @JvmName("chgbnvqybuidipnw")
    public suspend fun environmentVariables(`value`: Output<List<EnvironmentVariableArgs>>) {
        this.environmentVariables = value
    }

    @JvmName("rbpsrydcdpfptmsq")
    public suspend fun environmentVariables(vararg values: Output<EnvironmentVariableArgs>) {
        this.environmentVariables = Output.all(values.asList())
    }

    /**
     * @param values The environment variables to set in the container instance.
     */
    @JvmName("artppcxgtwplxgns")
    public suspend fun environmentVariables(values: List<Output<EnvironmentVariableArgs>>) {
        this.environmentVariables = Output.all(values)
    }

    /**
     * @param value The name of the image used to create the container instance.
     */
    @JvmName("pjgbbkasiyxweayf")
    public suspend fun image(`value`: Output<String>) {
        this.image = value
    }

    /**
     * @param value The liveness probe.
     */
    @JvmName("yqqyowhoutkjgyoi")
    public suspend fun livenessProbe(`value`: Output<ContainerProbeArgs>) {
        this.livenessProbe = value
    }

    /**
     * @param value The user-provided name of the container instance.
     */
    @JvmName("ushhpfwswjqoqajp")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The exposed ports on the container instance.
     */
    @JvmName("pwjerietwilowkec")
    public suspend fun ports(`value`: Output<List<ContainerPortArgs>>) {
        this.ports = value
    }

    @JvmName("drnauawrbgetvkyx")
    public suspend fun ports(vararg values: Output<ContainerPortArgs>) {
        this.ports = Output.all(values.asList())
    }

    /**
     * @param values The exposed ports on the container instance.
     */
    @JvmName("ufcxjobsbfhjjwnl")
    public suspend fun ports(values: List<Output<ContainerPortArgs>>) {
        this.ports = Output.all(values)
    }

    /**
     * @param value The readiness probe.
     */
    @JvmName("elrbkalqmhkytbrk")
    public suspend fun readinessProbe(`value`: Output<ContainerProbeArgs>) {
        this.readinessProbe = value
    }

    /**
     * @param value The resource requirements of the container instance.
     */
    @JvmName("dtfcvkukvmyhpijq")
    public suspend fun resources(`value`: Output<ResourceRequirementsArgs>) {
        this.resources = value
    }

    /**
     * @param value The container security properties.
     */
    @JvmName("dlggnrxlhjpvgntr")
    public suspend fun securityContext(`value`: Output<SecurityContextDefinitionArgs>) {
        this.securityContext = value
    }

    /**
     * @param value The volume mounts available to the container instance.
     */
    @JvmName("dfmdggbxduxycasv")
    public suspend fun volumeMounts(`value`: Output<List<VolumeMountArgs>>) {
        this.volumeMounts = value
    }

    @JvmName("gmucydatmheeinds")
    public suspend fun volumeMounts(vararg values: Output<VolumeMountArgs>) {
        this.volumeMounts = Output.all(values.asList())
    }

    /**
     * @param values The volume mounts available to the container instance.
     */
    @JvmName("ryyajbavmdbplnja")
    public suspend fun volumeMounts(values: List<Output<VolumeMountArgs>>) {
        this.volumeMounts = Output.all(values)
    }

    /**
     * @param value The commands to execute within the container instance in exec form.
     */
    @JvmName("kanfscrtwqhjpbkj")
    public suspend fun command(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.command = mapped
    }

    /**
     * @param values The commands to execute within the container instance in exec form.
     */
    @JvmName("vlyvsjynmxsogqma")
    public suspend fun command(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.command = mapped
    }

    /**
     * @param value The environment variables to set in the container instance.
     */
    @JvmName("urjjtellamjjilvi")
    public suspend fun environmentVariables(`value`: List<EnvironmentVariableArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.environmentVariables = mapped
    }

    /**
     * @param argument The environment variables to set in the container instance.
     */
    @JvmName("gutfsmthdiqhtlxt")
    public suspend
    fun environmentVariables(argument: List<suspend EnvironmentVariableArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            EnvironmentVariableArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.environmentVariables = mapped
    }

    /**
     * @param argument The environment variables to set in the container instance.
     */
    @JvmName("rfmmrceumgmbomfo")
    public suspend fun environmentVariables(
        vararg
        argument: suspend EnvironmentVariableArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            EnvironmentVariableArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.environmentVariables = mapped
    }

    /**
     * @param argument The environment variables to set in the container instance.
     */
    @JvmName("arikuootqfptgdfk")
    public suspend
    fun environmentVariables(argument: suspend EnvironmentVariableArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(EnvironmentVariableArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.environmentVariables = mapped
    }

    /**
     * @param values The environment variables to set in the container instance.
     */
    @JvmName("itobalvfstbxtxay")
    public suspend fun environmentVariables(vararg values: EnvironmentVariableArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.environmentVariables = mapped
    }

    /**
     * @param value The name of the image used to create the container instance.
     */
    @JvmName("yurvdqgpkuamwmry")
    public suspend fun image(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.image = mapped
    }

    /**
     * @param value The liveness probe.
     */
    @JvmName("ysspykwpwgdxuapa")
    public suspend fun livenessProbe(`value`: ContainerProbeArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.livenessProbe = mapped
    }

    /**
     * @param argument The liveness probe.
     */
    @JvmName("yexjljrxqsnbxkww")
    public suspend fun livenessProbe(argument: suspend ContainerProbeArgsBuilder.() -> Unit) {
        val toBeMapped = ContainerProbeArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.livenessProbe = mapped
    }

    /**
     * @param value The user-provided name of the container instance.
     */
    @JvmName("coeabfqlebcybbyr")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The exposed ports on the container instance.
     */
    @JvmName("dqiatlfgkprnvvhk")
    public suspend fun ports(`value`: List<ContainerPortArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ports = mapped
    }

    /**
     * @param argument The exposed ports on the container instance.
     */
    @JvmName("hjapjigdxjphfhjh")
    public suspend fun ports(argument: List<suspend ContainerPortArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ContainerPortArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.ports = mapped
    }

    /**
     * @param argument The exposed ports on the container instance.
     */
    @JvmName("aclyqjphkywnukib")
    public suspend fun ports(vararg argument: suspend ContainerPortArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ContainerPortArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.ports = mapped
    }

    /**
     * @param argument The exposed ports on the container instance.
     */
    @JvmName("owlmeygjjldtgcbf")
    public suspend fun ports(argument: suspend ContainerPortArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(ContainerPortArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.ports = mapped
    }

    /**
     * @param values The exposed ports on the container instance.
     */
    @JvmName("jwvaxubyledjinhy")
    public suspend fun ports(vararg values: ContainerPortArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ports = mapped
    }

    /**
     * @param value The readiness probe.
     */
    @JvmName("kemkvlajvtwplctm")
    public suspend fun readinessProbe(`value`: ContainerProbeArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.readinessProbe = mapped
    }

    /**
     * @param argument The readiness probe.
     */
    @JvmName("aduookcxfdymyakn")
    public suspend fun readinessProbe(argument: suspend ContainerProbeArgsBuilder.() -> Unit) {
        val toBeMapped = ContainerProbeArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.readinessProbe = mapped
    }

    /**
     * @param value The resource requirements of the container instance.
     */
    @JvmName("oxmvwegeyrrdbqmp")
    public suspend fun resources(`value`: ResourceRequirementsArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.resources = mapped
    }

    /**
     * @param argument The resource requirements of the container instance.
     */
    @JvmName("oosqlgnfkdomaffh")
    public suspend fun resources(argument: suspend ResourceRequirementsArgsBuilder.() -> Unit) {
        val toBeMapped = ResourceRequirementsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.resources = mapped
    }

    /**
     * @param value The container security properties.
     */
    @JvmName("utcgxvhistmvywdg")
    public suspend fun securityContext(`value`: SecurityContextDefinitionArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.securityContext = mapped
    }

    /**
     * @param argument The container security properties.
     */
    @JvmName("kuuklrysmbslynll")
    public suspend
    fun securityContext(argument: suspend SecurityContextDefinitionArgsBuilder.() -> Unit) {
        val toBeMapped = SecurityContextDefinitionArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.securityContext = mapped
    }

    /**
     * @param value The volume mounts available to the container instance.
     */
    @JvmName("phdhqwjlrpiwyixo")
    public suspend fun volumeMounts(`value`: List<VolumeMountArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.volumeMounts = mapped
    }

    /**
     * @param argument The volume mounts available to the container instance.
     */
    @JvmName("jxhgqcdxfcmjecif")
    public suspend fun volumeMounts(argument: List<suspend VolumeMountArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { VolumeMountArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.volumeMounts = mapped
    }

    /**
     * @param argument The volume mounts available to the container instance.
     */
    @JvmName("wigxuyknkgtsogby")
    public suspend fun volumeMounts(vararg argument: suspend VolumeMountArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { VolumeMountArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.volumeMounts = mapped
    }

    /**
     * @param argument The volume mounts available to the container instance.
     */
    @JvmName("kudcidfloixavlfr")
    public suspend fun volumeMounts(argument: suspend VolumeMountArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(VolumeMountArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.volumeMounts = mapped
    }

    /**
     * @param values The volume mounts available to the container instance.
     */
    @JvmName("grcryuufocfixhch")
    public suspend fun volumeMounts(vararg values: VolumeMountArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.volumeMounts = mapped
    }

    internal fun build(): ContainerArgs = ContainerArgs(
        command = command,
        environmentVariables = environmentVariables,
        image = image ?: throw PulumiNullFieldException("image"),
        livenessProbe = livenessProbe,
        name = name ?: throw PulumiNullFieldException("name"),
        ports = ports,
        readinessProbe = readinessProbe,
        resources = resources ?: throw PulumiNullFieldException("resources"),
        securityContext = securityContext,
        volumeMounts = volumeMounts,
    )
}
