@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerinstance.kotlin.inputs

import com.pulumi.azurenative.containerinstance.inputs.EncryptionPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The container group encryption properties.
 * @property identity The keyvault managed identity.
 * @property keyName The encryption key name.
 * @property keyVersion The encryption key version.
 * @property vaultBaseUrl The keyvault base url.
 */
public data class EncryptionPropertiesArgs(
    public val identity: Output<String>? = null,
    public val keyName: Output<String>,
    public val keyVersion: Output<String>,
    public val vaultBaseUrl: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.containerinstance.inputs.EncryptionPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.containerinstance.inputs.EncryptionPropertiesArgs =
        com.pulumi.azurenative.containerinstance.inputs.EncryptionPropertiesArgs.builder()
            .identity(identity?.applyValue({ args0 -> args0 }))
            .keyName(keyName.applyValue({ args0 -> args0 }))
            .keyVersion(keyVersion.applyValue({ args0 -> args0 }))
            .vaultBaseUrl(vaultBaseUrl.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [EncryptionPropertiesArgs].
 */
@PulumiTagMarker
public class EncryptionPropertiesArgsBuilder internal constructor() {
    private var identity: Output<String>? = null

    private var keyName: Output<String>? = null

    private var keyVersion: Output<String>? = null

    private var vaultBaseUrl: Output<String>? = null

    /**
     * @param value The keyvault managed identity.
     */
    @JvmName("kvjjljibqhpaigxc")
    public suspend fun identity(`value`: Output<String>) {
        this.identity = value
    }

    /**
     * @param value The encryption key name.
     */
    @JvmName("mbhnjmcsqdovigww")
    public suspend fun keyName(`value`: Output<String>) {
        this.keyName = value
    }

    /**
     * @param value The encryption key version.
     */
    @JvmName("klnsfthudpslddya")
    public suspend fun keyVersion(`value`: Output<String>) {
        this.keyVersion = value
    }

    /**
     * @param value The keyvault base url.
     */
    @JvmName("jnvwuubellglsunh")
    public suspend fun vaultBaseUrl(`value`: Output<String>) {
        this.vaultBaseUrl = value
    }

    /**
     * @param value The keyvault managed identity.
     */
    @JvmName("snwccgelsmlicprs")
    public suspend fun identity(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.identity = mapped
    }

    /**
     * @param value The encryption key name.
     */
    @JvmName("thtvwrijwtkhqkqh")
    public suspend fun keyName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.keyName = mapped
    }

    /**
     * @param value The encryption key version.
     */
    @JvmName("ugnixhxhbhsapram")
    public suspend fun keyVersion(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.keyVersion = mapped
    }

    /**
     * @param value The keyvault base url.
     */
    @JvmName("cforfncbkpdirele")
    public suspend fun vaultBaseUrl(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.vaultBaseUrl = mapped
    }

    internal fun build(): EncryptionPropertiesArgs = EncryptionPropertiesArgs(
        identity = identity,
        keyName = keyName ?: throw PulumiNullFieldException("keyName"),
        keyVersion = keyVersion ?: throw PulumiNullFieldException("keyVersion"),
        vaultBaseUrl = vaultBaseUrl ?: throw PulumiNullFieldException("vaultBaseUrl"),
    )
}
