@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerinstance.kotlin.inputs

import com.pulumi.azurenative.containerinstance.inputs.IpAddressArgs.builder
import com.pulumi.azurenative.containerinstance.kotlin.enums.ContainerGroupIpAddressType
import com.pulumi.azurenative.containerinstance.kotlin.enums.DnsNameLabelReusePolicy
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * IP address for the container group.
 * @property autoGeneratedDomainNameLabelScope The value representing the security enum. The 'Unsecure' value is the default value if not selected and means the object's domain name label is not secured against subdomain takeover. The 'TenantReuse' value is the default value if selected and means the object's domain name label can be reused within the same tenant. The 'SubscriptionReuse' value means the object's domain name label can be reused within the same subscription. The 'ResourceGroupReuse' value means the object's domain name label can be reused within the same resource group. The 'NoReuse' value means the object's domain name label cannot be reused within the same resource group, subscription, or tenant.
 * @property dnsNameLabel The Dns name label for the IP.
 * @property ip The IP exposed to the public internet.
 * @property ports The list of ports exposed on the container group.
 * @property type Specifies if the IP is exposed to the public internet or private VNET.
 */
public data class IpAddressArgs(
    public val autoGeneratedDomainNameLabelScope: Output<Either<String, DnsNameLabelReusePolicy>>? =
        null,
    public val dnsNameLabel: Output<String>? = null,
    public val ip: Output<String>? = null,
    public val ports: Output<List<PortArgs>>,
    public val type: Output<Either<String, ContainerGroupIpAddressType>>,
) : ConvertibleToJava<com.pulumi.azurenative.containerinstance.inputs.IpAddressArgs> {
    override fun toJava(): com.pulumi.azurenative.containerinstance.inputs.IpAddressArgs =
        com.pulumi.azurenative.containerinstance.inputs.IpAddressArgs.builder()
            .autoGeneratedDomainNameLabelScope(
                autoGeneratedDomainNameLabelScope?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .dnsNameLabel(dnsNameLabel?.applyValue({ args0 -> args0 }))
            .ip(ip?.applyValue({ args0 -> args0 }))
            .ports(ports.applyValue({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .type(
                type.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [IpAddressArgs].
 */
@PulumiTagMarker
public class IpAddressArgsBuilder internal constructor() {
    private var autoGeneratedDomainNameLabelScope: Output<Either<String, DnsNameLabelReusePolicy>>? =
        null

    private var dnsNameLabel: Output<String>? = null

    private var ip: Output<String>? = null

    private var ports: Output<List<PortArgs>>? = null

    private var type: Output<Either<String, ContainerGroupIpAddressType>>? = null

    /**
     * @param value The value representing the security enum. The 'Unsecure' value is the default value if not selected and means the object's domain name label is not secured against subdomain takeover. The 'TenantReuse' value is the default value if selected and means the object's domain name label can be reused within the same tenant. The 'SubscriptionReuse' value means the object's domain name label can be reused within the same subscription. The 'ResourceGroupReuse' value means the object's domain name label can be reused within the same resource group. The 'NoReuse' value means the object's domain name label cannot be reused within the same resource group, subscription, or tenant.
     */
    @JvmName("uqqolqpkmlehdeuf")
    public suspend
    fun autoGeneratedDomainNameLabelScope(`value`: Output<Either<String, DnsNameLabelReusePolicy>>) {
        this.autoGeneratedDomainNameLabelScope = value
    }

    /**
     * @param value The Dns name label for the IP.
     */
    @JvmName("ctfqhlprrtepmrju")
    public suspend fun dnsNameLabel(`value`: Output<String>) {
        this.dnsNameLabel = value
    }

    /**
     * @param value The IP exposed to the public internet.
     */
    @JvmName("gebahexmrrftonaa")
    public suspend fun ip(`value`: Output<String>) {
        this.ip = value
    }

    /**
     * @param value The list of ports exposed on the container group.
     */
    @JvmName("xhbpulerpmoeoggc")
    public suspend fun ports(`value`: Output<List<PortArgs>>) {
        this.ports = value
    }

    @JvmName("hdtbmuoaygugfhkn")
    public suspend fun ports(vararg values: Output<PortArgs>) {
        this.ports = Output.all(values.asList())
    }

    /**
     * @param values The list of ports exposed on the container group.
     */
    @JvmName("pqnihjonyefwvgvs")
    public suspend fun ports(values: List<Output<PortArgs>>) {
        this.ports = Output.all(values)
    }

    /**
     * @param value Specifies if the IP is exposed to the public internet or private VNET.
     */
    @JvmName("llxbvfkuhiiyqidr")
    public suspend fun type(`value`: Output<Either<String, ContainerGroupIpAddressType>>) {
        this.type = value
    }

    /**
     * @param value The value representing the security enum. The 'Unsecure' value is the default value if not selected and means the object's domain name label is not secured against subdomain takeover. The 'TenantReuse' value is the default value if selected and means the object's domain name label can be reused within the same tenant. The 'SubscriptionReuse' value means the object's domain name label can be reused within the same subscription. The 'ResourceGroupReuse' value means the object's domain name label can be reused within the same resource group. The 'NoReuse' value means the object's domain name label cannot be reused within the same resource group, subscription, or tenant.
     */
    @JvmName("jukusytmckxdulft")
    public suspend
    fun autoGeneratedDomainNameLabelScope(`value`: Either<String, DnsNameLabelReusePolicy>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoGeneratedDomainNameLabelScope = mapped
    }

    /**
     * @param value The value representing the security enum. The 'Unsecure' value is the default value if not selected and means the object's domain name label is not secured against subdomain takeover. The 'TenantReuse' value is the default value if selected and means the object's domain name label can be reused within the same tenant. The 'SubscriptionReuse' value means the object's domain name label can be reused within the same subscription. The 'ResourceGroupReuse' value means the object's domain name label can be reused within the same resource group. The 'NoReuse' value means the object's domain name label cannot be reused within the same resource group, subscription, or tenant.
     */
    @JvmName("wlodnvosvdqscuag")
    public fun autoGeneratedDomainNameLabelScope(`value`: String) {
        val toBeMapped = Either.ofLeft<String, DnsNameLabelReusePolicy>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.autoGeneratedDomainNameLabelScope = mapped
    }

    /**
     * @param value The value representing the security enum. The 'Unsecure' value is the default value if not selected and means the object's domain name label is not secured against subdomain takeover. The 'TenantReuse' value is the default value if selected and means the object's domain name label can be reused within the same tenant. The 'SubscriptionReuse' value means the object's domain name label can be reused within the same subscription. The 'ResourceGroupReuse' value means the object's domain name label can be reused within the same resource group. The 'NoReuse' value means the object's domain name label cannot be reused within the same resource group, subscription, or tenant.
     */
    @JvmName("wmelpmgsbmubouwq")
    public fun autoGeneratedDomainNameLabelScope(`value`: DnsNameLabelReusePolicy) {
        val toBeMapped = Either.ofRight<String, DnsNameLabelReusePolicy>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.autoGeneratedDomainNameLabelScope = mapped
    }

    /**
     * @param value The Dns name label for the IP.
     */
    @JvmName("ntqmbnwbgcbhjyyt")
    public suspend fun dnsNameLabel(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dnsNameLabel = mapped
    }

    /**
     * @param value The IP exposed to the public internet.
     */
    @JvmName("dowanbyoglemscwm")
    public suspend fun ip(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ip = mapped
    }

    /**
     * @param value The list of ports exposed on the container group.
     */
    @JvmName("tkpfhodnsxldngir")
    public suspend fun ports(`value`: List<PortArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ports = mapped
    }

    /**
     * @param argument The list of ports exposed on the container group.
     */
    @JvmName("sqqmpfflkpbijtxy")
    public suspend fun ports(argument: List<suspend PortArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { PortArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.ports = mapped
    }

    /**
     * @param argument The list of ports exposed on the container group.
     */
    @JvmName("gqfwttvgnneoiwew")
    public suspend fun ports(vararg argument: suspend PortArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { PortArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.ports = mapped
    }

    /**
     * @param argument The list of ports exposed on the container group.
     */
    @JvmName("exmsjdvhgyxlmcey")
    public suspend fun ports(argument: suspend PortArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(PortArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.ports = mapped
    }

    /**
     * @param values The list of ports exposed on the container group.
     */
    @JvmName("rallutjnlcrkjkwe")
    public suspend fun ports(vararg values: PortArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ports = mapped
    }

    /**
     * @param value Specifies if the IP is exposed to the public internet or private VNET.
     */
    @JvmName("dxholnrcriekuylf")
    public suspend fun type(`value`: Either<String, ContainerGroupIpAddressType>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Specifies if the IP is exposed to the public internet or private VNET.
     */
    @JvmName("jyrantohcrmtpuor")
    public fun type(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ContainerGroupIpAddressType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Specifies if the IP is exposed to the public internet or private VNET.
     */
    @JvmName("uudyhacuiwgtpjpv")
    public fun type(`value`: ContainerGroupIpAddressType) {
        val toBeMapped = Either.ofRight<String, ContainerGroupIpAddressType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): IpAddressArgs = IpAddressArgs(
        autoGeneratedDomainNameLabelScope = autoGeneratedDomainNameLabelScope,
        dnsNameLabel = dnsNameLabel,
        ip = ip,
        ports = ports ?: throw PulumiNullFieldException("ports"),
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
