@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerinstance.kotlin.inputs

import com.pulumi.azurenative.containerinstance.inputs.ResourceRequirementsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * The resource requirements.
 * @property limits The resource limits of this container instance.
 * @property requests The resource requests of this container instance.
 */
public data class ResourceRequirementsArgs(
    public val limits: Output<ResourceLimitsArgs>? = null,
    public val requests: Output<ResourceRequestsArgs>,
) : ConvertibleToJava<com.pulumi.azurenative.containerinstance.inputs.ResourceRequirementsArgs> {
    override fun toJava(): com.pulumi.azurenative.containerinstance.inputs.ResourceRequirementsArgs =
        com.pulumi.azurenative.containerinstance.inputs.ResourceRequirementsArgs.builder()
            .limits(limits?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .requests(requests.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [ResourceRequirementsArgs].
 */
@PulumiTagMarker
public class ResourceRequirementsArgsBuilder internal constructor() {
    private var limits: Output<ResourceLimitsArgs>? = null

    private var requests: Output<ResourceRequestsArgs>? = null

    /**
     * @param value The resource limits of this container instance.
     */
    @JvmName("lfypuurwtjtfuacb")
    public suspend fun limits(`value`: Output<ResourceLimitsArgs>) {
        this.limits = value
    }

    /**
     * @param value The resource requests of this container instance.
     */
    @JvmName("sjdujitjapbuqqrd")
    public suspend fun requests(`value`: Output<ResourceRequestsArgs>) {
        this.requests = value
    }

    /**
     * @param value The resource limits of this container instance.
     */
    @JvmName("dfvtchmsexnyedgd")
    public suspend fun limits(`value`: ResourceLimitsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.limits = mapped
    }

    /**
     * @param argument The resource limits of this container instance.
     */
    @JvmName("qhodlpuoeaumckig")
    public suspend fun limits(argument: suspend ResourceLimitsArgsBuilder.() -> Unit) {
        val toBeMapped = ResourceLimitsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.limits = mapped
    }

    /**
     * @param value The resource requests of this container instance.
     */
    @JvmName("eyvcktliatxkcuux")
    public suspend fun requests(`value`: ResourceRequestsArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.requests = mapped
    }

    /**
     * @param argument The resource requests of this container instance.
     */
    @JvmName("kuqbnynhqmqafbmw")
    public suspend fun requests(argument: suspend ResourceRequestsArgsBuilder.() -> Unit) {
        val toBeMapped = ResourceRequestsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.requests = mapped
    }

    internal fun build(): ResourceRequirementsArgs = ResourceRequirementsArgs(
        limits = limits,
        requests = requests ?: throw PulumiNullFieldException("requests"),
    )
}
