@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerinstance.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 * The properties of the Azure File volume. Azure File shares are mounted as volumes.
 * @property readOnly The flag indicating whether the Azure File shared mounted as a volume is read-only.
 * @property shareName The name of the Azure File share to be mounted as a volume.
 * @property storageAccountKey The storage account access key used to access the Azure File share.
 * @property storageAccountName The name of the storage account that contains the Azure File share.
 */
public data class AzureFileVolumeResponse(
    public val readOnly: Boolean? = null,
    public val shareName: String,
    public val storageAccountKey: String? = null,
    public val storageAccountName: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.containerinstance.outputs.AzureFileVolumeResponse):
            AzureFileVolumeResponse = AzureFileVolumeResponse(
            readOnly = javaType.readOnly().map({ args0 -> args0 }).orElse(null),
            shareName = javaType.shareName(),
            storageAccountKey = javaType.storageAccountKey().map({ args0 -> args0 }).orElse(null),
            storageAccountName = javaType.storageAccountName(),
        )
    }
}
