@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerinstance.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * The container Http Get settings, for liveness or readiness probe
 * @property httpHeaders The HTTP headers.
 * @property path The path to probe.
 * @property port The port number to probe.
 * @property scheme The scheme.
 */
public data class ContainerHttpGetResponse(
    public val httpHeaders: List<HttpHeaderResponse>? = null,
    public val path: String? = null,
    public val port: Int,
    public val scheme: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.containerinstance.outputs.ContainerHttpGetResponse):
            ContainerHttpGetResponse = ContainerHttpGetResponse(
            httpHeaders = javaType.httpHeaders().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.containerinstance.kotlin.outputs.HttpHeaderResponse.Companion.toKotlin(args0)
                })
            }),
            path = javaType.path().map({ args0 -> args0 }).orElse(null),
            port = javaType.port(),
            scheme = javaType.scheme().map({ args0 -> args0 }).orElse(null),
        )
    }
}
