@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerinstance.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * A container group.
 * @property confidentialComputeProperties The properties for confidential container group
 * @property containers The containers within the container group.
 * @property diagnostics The diagnostic information for a container group.
 * @property dnsConfig The DNS config information for a container group.
 * @property encryptionProperties The encryption properties for a container group.
 * @property extensions extensions used by virtual kubelet
 * @property id The resource id.
 * @property identity The identity of the container group, if configured.
 * @property imageRegistryCredentials The image registry credentials by which the container group is created from.
 * @property initContainers The init containers for a container group.
 * @property instanceView The instance view of the container group. Only valid in response.
 * @property ipAddress The IP address type of the container group.
 * @property location The resource location.
 * @property name The resource name.
 * @property osType The operating system type required by the containers in the container group.
 * @property priority The priority of the container group.
 * @property provisioningState The provisioning state of the container group. This only appears in the response.
 * @property restartPolicy Restart policy for all containers within the container group.
 * - `Always` Always restart
 * - `OnFailure` Restart on failure
 * - `Never` Never restart
 * @property sku The SKU for a container group.
 * @property subnetIds The subnet resource IDs for a container group.
 * @property tags The resource tags.
 * @property type The resource type.
 * @property volumes The list of volumes that can be mounted by containers in this container group.
 * @property zones The zones for the container group.
 */
public data class GetContainerGroupResult(
    public val confidentialComputeProperties: ConfidentialComputePropertiesResponse? = null,
    public val containers: List<ContainerResponse>,
    public val diagnostics: ContainerGroupDiagnosticsResponse? = null,
    public val dnsConfig: DnsConfigurationResponse? = null,
    public val encryptionProperties: EncryptionPropertiesResponse? = null,
    public val extensions: List<DeploymentExtensionSpecResponse>? = null,
    public val id: String,
    public val identity: ContainerGroupIdentityResponse? = null,
    public val imageRegistryCredentials: List<ImageRegistryCredentialResponse>? = null,
    public val initContainers: List<InitContainerDefinitionResponse>? = null,
    public val instanceView: ContainerGroupPropertiesResponseInstanceView,
    public val ipAddress: IpAddressResponse? = null,
    public val location: String? = null,
    public val name: String,
    public val osType: String,
    public val priority: String? = null,
    public val provisioningState: String,
    public val restartPolicy: String? = null,
    public val sku: String? = null,
    public val subnetIds: List<ContainerGroupSubnetIdResponse>? = null,
    public val tags: Map<String, String>? = null,
    public val type: String,
    public val volumes: List<VolumeResponse>? = null,
    public val zones: List<String>? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.containerinstance.outputs.GetContainerGroupResult):
            GetContainerGroupResult = GetContainerGroupResult(
            confidentialComputeProperties = javaType.confidentialComputeProperties().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.containerinstance.kotlin.outputs.ConfidentialComputePropertiesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            containers = javaType.containers().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.containerinstance.kotlin.outputs.ContainerResponse.Companion.toKotlin(args0)
                })
            }),
            diagnostics = javaType.diagnostics().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.containerinstance.kotlin.outputs.ContainerGroupDiagnosticsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            dnsConfig = javaType.dnsConfig().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.containerinstance.kotlin.outputs.DnsConfigurationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            encryptionProperties = javaType.encryptionProperties().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.containerinstance.kotlin.outputs.EncryptionPropertiesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            extensions = javaType.extensions().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.containerinstance.kotlin.outputs.DeploymentExtensionSpecResponse.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id(),
            identity = javaType.identity().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.containerinstance.kotlin.outputs.ContainerGroupIdentityResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            imageRegistryCredentials = javaType.imageRegistryCredentials().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.containerinstance.kotlin.outputs.ImageRegistryCredentialResponse.Companion.toKotlin(args0)
                })
            }),
            initContainers = javaType.initContainers().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.containerinstance.kotlin.outputs.InitContainerDefinitionResponse.Companion.toKotlin(args0)
                })
            }),
            instanceView = javaType.instanceView().let({ args0 ->
                com.pulumi.azurenative.containerinstance.kotlin.outputs.ContainerGroupPropertiesResponseInstanceView.Companion.toKotlin(args0)
            }),
            ipAddress = javaType.ipAddress().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.containerinstance.kotlin.outputs.IpAddressResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            location = javaType.location().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            osType = javaType.osType(),
            priority = javaType.priority().map({ args0 -> args0 }).orElse(null),
            provisioningState = javaType.provisioningState(),
            restartPolicy = javaType.restartPolicy().map({ args0 -> args0 }).orElse(null),
            sku = javaType.sku().map({ args0 -> args0 }).orElse(null),
            subnetIds = javaType.subnetIds().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.containerinstance.kotlin.outputs.ContainerGroupSubnetIdResponse.Companion.toKotlin(args0)
                })
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
            volumes = javaType.volumes().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.containerinstance.kotlin.outputs.VolumeResponse.Companion.toKotlin(args0)
                })
            }),
            zones = javaType.zones().map({ args0 -> args0 }),
        )
    }
}
