@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerinstance.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * The capabilities to add or drop from a container.
 * @property add The capabilities to add to the container.
 * @property drop The capabilities to drop from the container.
 */
public data class SecurityContextCapabilitiesDefinitionResponse(
    public val add: List<String>? = null,
    public val drop: List<String>? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.containerinstance.outputs.SecurityContextCapabilitiesDefinitionResponse):
            SecurityContextCapabilitiesDefinitionResponse =
            SecurityContextCapabilitiesDefinitionResponse(
                add = javaType.add().map({ args0 -> args0 }),
                drop = javaType.drop().map({ args0 -> args0 }),
            )
    }
}
