@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerinstance.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 * The properties of the volume mount.
 * @property mountPath The path within the container where the volume should be mounted. Must not contain colon (:).
 * @property name The name of the volume mount.
 * @property readOnly The flag indicating whether the volume mount is read-only.
 */
public data class VolumeMountResponse(
    public val mountPath: String,
    public val name: String,
    public val readOnly: Boolean? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.containerinstance.outputs.VolumeMountResponse):
            VolumeMountResponse = VolumeMountResponse(
            mountPath = javaType.mountPath(),
            name = javaType.name(),
            readOnly = javaType.readOnly().map({ args0 -> args0 }).orElse(null),
        )
    }
}
