@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerregistry.kotlin

import com.pulumi.azurenative.containerregistry.ArchifeArgs.builder
import com.pulumi.azurenative.containerregistry.kotlin.inputs.ArchivePackageSourcePropertiesArgs
import com.pulumi.azurenative.containerregistry.kotlin.inputs.ArchivePackageSourcePropertiesArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * An object that represents a archive for a container registry.
 * Azure REST API version: 2023-06-01-preview.
 * Other available API versions: 2023-08-01-preview, 2023-11-01-preview.
 * ## Example Usage
 * ### ArchiveCreate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var archife = new AzureNative.ContainerRegistry.Archife("archife", new()
 *     {
 *         ArchiveName = "myArchiveName",
 *         PackageSource = new AzureNative.ContainerRegistry.Inputs.ArchivePackageSourcePropertiesArgs
 *         {
 *             Type = "remote",
 *             Url = "string",
 *         },
 *         PackageType = "rpm",
 *         PublishedVersion = "string",
 *         RegistryName = "myRegistry",
 *         RepositoryEndpointPrefix = "string",
 *         ResourceGroupName = "myResourceGroup",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/containerregistry/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := containerregistry.NewArchife(ctx, "archife", &containerregistry.ArchifeArgs{
 * 			ArchiveName: pulumi.String("myArchiveName"),
 * 			PackageSource: &containerregistry.ArchivePackageSourcePropertiesArgs{
 * 				Type: pulumi.String("remote"),
 * 				Url:  pulumi.String("string"),
 * 			},
 * 			PackageType:              pulumi.String("rpm"),
 * 			PublishedVersion:         pulumi.String("string"),
 * 			RegistryName:             pulumi.String("myRegistry"),
 * 			RepositoryEndpointPrefix: pulumi.String("string"),
 * 			ResourceGroupName:        pulumi.String("myResourceGroup"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.containerregistry.Archife;
 * import com.pulumi.azurenative.containerregistry.ArchifeArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var archife = new Archife("archife", ArchifeArgs.builder()
 *             .archiveName("myArchiveName")
 *             .packageSource(Map.ofEntries(
 *                 Map.entry("type", "remote"),
 *                 Map.entry("url", "string")
 *             ))
 *             .packageType("rpm")
 *             .publishedVersion("string")
 *             .registryName("myRegistry")
 *             .repositoryEndpointPrefix("string")
 *             .resourceGroupName("myResourceGroup")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:containerregistry:Archife myArchiveName /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerRegistry/registries/{registryName}/packages/{packageType}/archives/{archiveName}
 * ```
 * @property archiveName The name of the archive resource.
 * @property packageSource The package source of the archive.
 * @property packageType The type of the package resource.
 * @property publishedVersion The published version of the archive.
 * @property registryName The name of the container registry.
 * @property repositoryEndpointPrefix
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class ArchifeArgs(
    public val archiveName: Output<String>? = null,
    public val packageSource: Output<ArchivePackageSourcePropertiesArgs>? = null,
    public val packageType: Output<String>? = null,
    public val publishedVersion: Output<String>? = null,
    public val registryName: Output<String>? = null,
    public val repositoryEndpointPrefix: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.containerregistry.ArchifeArgs> {
    override fun toJava(): com.pulumi.azurenative.containerregistry.ArchifeArgs =
        com.pulumi.azurenative.containerregistry.ArchifeArgs.builder()
            .archiveName(archiveName?.applyValue({ args0 -> args0 }))
            .packageSource(packageSource?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .packageType(packageType?.applyValue({ args0 -> args0 }))
            .publishedVersion(publishedVersion?.applyValue({ args0 -> args0 }))
            .registryName(registryName?.applyValue({ args0 -> args0 }))
            .repositoryEndpointPrefix(repositoryEndpointPrefix?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ArchifeArgs].
 */
@PulumiTagMarker
public class ArchifeArgsBuilder internal constructor() {
    private var archiveName: Output<String>? = null

    private var packageSource: Output<ArchivePackageSourcePropertiesArgs>? = null

    private var packageType: Output<String>? = null

    private var publishedVersion: Output<String>? = null

    private var registryName: Output<String>? = null

    private var repositoryEndpointPrefix: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    /**
     * @param value The name of the archive resource.
     */
    @JvmName("lcvuvmajjoqodgto")
    public suspend fun archiveName(`value`: Output<String>) {
        this.archiveName = value
    }

    /**
     * @param value The package source of the archive.
     */
    @JvmName("shkeclokpopbefwe")
    public suspend fun packageSource(`value`: Output<ArchivePackageSourcePropertiesArgs>) {
        this.packageSource = value
    }

    /**
     * @param value The type of the package resource.
     */
    @JvmName("tkpjdvxtikbvtxjw")
    public suspend fun packageType(`value`: Output<String>) {
        this.packageType = value
    }

    /**
     * @param value The published version of the archive.
     */
    @JvmName("lexudhnarolonxss")
    public suspend fun publishedVersion(`value`: Output<String>) {
        this.publishedVersion = value
    }

    /**
     * @param value The name of the container registry.
     */
    @JvmName("fkctkameaxbyojya")
    public suspend fun registryName(`value`: Output<String>) {
        this.registryName = value
    }

    /**
     * @param value
     */
    @JvmName("jcrqusuusuinqxjj")
    public suspend fun repositoryEndpointPrefix(`value`: Output<String>) {
        this.repositoryEndpointPrefix = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("xuehfgbmghpsgslf")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the archive resource.
     */
    @JvmName("lnxxocefofplucna")
    public suspend fun archiveName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.archiveName = mapped
    }

    /**
     * @param value The package source of the archive.
     */
    @JvmName("qsiogqsepragtyoy")
    public suspend fun packageSource(`value`: ArchivePackageSourcePropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.packageSource = mapped
    }

    /**
     * @param argument The package source of the archive.
     */
    @JvmName("ohsmalsqgtufjqrf")
    public suspend
    fun packageSource(argument: suspend ArchivePackageSourcePropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = ArchivePackageSourcePropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.packageSource = mapped
    }

    /**
     * @param value The type of the package resource.
     */
    @JvmName("ytottagxgspdbkwk")
    public suspend fun packageType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.packageType = mapped
    }

    /**
     * @param value The published version of the archive.
     */
    @JvmName("iwrjmxroerrhdekk")
    public suspend fun publishedVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.publishedVersion = mapped
    }

    /**
     * @param value The name of the container registry.
     */
    @JvmName("nopghmtxvaoiksan")
    public suspend fun registryName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.registryName = mapped
    }

    /**
     * @param value
     */
    @JvmName("jmhorbfwpbyfiqbl")
    public suspend fun repositoryEndpointPrefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.repositoryEndpointPrefix = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("rgjxodoixxqabays")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    internal fun build(): ArchifeArgs = ArchifeArgs(
        archiveName = archiveName,
        packageSource = packageSource,
        packageType = packageType,
        publishedVersion = publishedVersion,
        registryName = registryName,
        repositoryEndpointPrefix = repositoryEndpointPrefix,
        resourceGroupName = resourceGroupName,
    )
}
