@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerregistry.kotlin

import com.pulumi.azurenative.containerregistry.ArchiveVersionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * An object that represents an export pipeline for a container registry.
 * Azure REST API version: 2023-06-01-preview.
 * Other available API versions: 2023-08-01-preview, 2023-11-01-preview.
 * ## Example Usage
 * ### ArchiveVersionCreate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var archiveVersion = new AzureNative.ContainerRegistry.ArchiveVersion("archiveVersion", new()
 *     {
 *         ArchiveName = "myArchiveName",
 *         ArchiveVersionName = "myArchiveVersionName",
 *         PackageType = "rpm",
 *         RegistryName = "myRegistry",
 *         ResourceGroupName = "myResourceGroup",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/containerregistry/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := containerregistry.NewArchiveVersion(ctx, "archiveVersion", &containerregistry.ArchiveVersionArgs{
 * 			ArchiveName:        pulumi.String("myArchiveName"),
 * 			ArchiveVersionName: pulumi.String("myArchiveVersionName"),
 * 			PackageType:        pulumi.String("rpm"),
 * 			RegistryName:       pulumi.String("myRegistry"),
 * 			ResourceGroupName:  pulumi.String("myResourceGroup"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.containerregistry.ArchiveVersion;
 * import com.pulumi.azurenative.containerregistry.ArchiveVersionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var archiveVersion = new ArchiveVersion("archiveVersion", ArchiveVersionArgs.builder()
 *             .archiveName("myArchiveName")
 *             .archiveVersionName("myArchiveVersionName")
 *             .packageType("rpm")
 *             .registryName("myRegistry")
 *             .resourceGroupName("myResourceGroup")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:containerregistry:ArchiveVersion myArchiveVersionName /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerRegistry/registries/{registryName}/packages/{packageType}/archives/{archiveName}/versions/{archiveVersionName}
 * ```
 * @property archiveName The name of the archive resource.
 * @property archiveVersionName The name of the archive version resource.
 * @property packageType The type of the package resource.
 * @property registryName The name of the container registry.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class ArchiveVersionArgs(
    public val archiveName: Output<String>? = null,
    public val archiveVersionName: Output<String>? = null,
    public val packageType: Output<String>? = null,
    public val registryName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.containerregistry.ArchiveVersionArgs> {
    override fun toJava(): com.pulumi.azurenative.containerregistry.ArchiveVersionArgs =
        com.pulumi.azurenative.containerregistry.ArchiveVersionArgs.builder()
            .archiveName(archiveName?.applyValue({ args0 -> args0 }))
            .archiveVersionName(archiveVersionName?.applyValue({ args0 -> args0 }))
            .packageType(packageType?.applyValue({ args0 -> args0 }))
            .registryName(registryName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ArchiveVersionArgs].
 */
@PulumiTagMarker
public class ArchiveVersionArgsBuilder internal constructor() {
    private var archiveName: Output<String>? = null

    private var archiveVersionName: Output<String>? = null

    private var packageType: Output<String>? = null

    private var registryName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    /**
     * @param value The name of the archive resource.
     */
    @JvmName("yoodqexfxhnkyxjq")
    public suspend fun archiveName(`value`: Output<String>) {
        this.archiveName = value
    }

    /**
     * @param value The name of the archive version resource.
     */
    @JvmName("uppfuqpknxnsarkf")
    public suspend fun archiveVersionName(`value`: Output<String>) {
        this.archiveVersionName = value
    }

    /**
     * @param value The type of the package resource.
     */
    @JvmName("uftisoqwapnyrmgh")
    public suspend fun packageType(`value`: Output<String>) {
        this.packageType = value
    }

    /**
     * @param value The name of the container registry.
     */
    @JvmName("rtqewluhcucefdgh")
    public suspend fun registryName(`value`: Output<String>) {
        this.registryName = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("umdjehfoyfrgggjr")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the archive resource.
     */
    @JvmName("xdypmmishdhmrpne")
    public suspend fun archiveName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.archiveName = mapped
    }

    /**
     * @param value The name of the archive version resource.
     */
    @JvmName("aewxtemvaagxjmol")
    public suspend fun archiveVersionName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.archiveVersionName = mapped
    }

    /**
     * @param value The type of the package resource.
     */
    @JvmName("ugbfxsyapvttodgi")
    public suspend fun packageType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.packageType = mapped
    }

    /**
     * @param value The name of the container registry.
     */
    @JvmName("pctcjsdqplybnjrf")
    public suspend fun registryName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.registryName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("lbmxdadmgquqjpjn")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    internal fun build(): ArchiveVersionArgs = ArchiveVersionArgs(
        archiveName = archiveName,
        archiveVersionName = archiveVersionName,
        packageType = packageType,
        registryName = registryName,
        resourceGroupName = resourceGroupName,
    )
}
