@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerregistry.kotlin

import com.pulumi.azurenative.containerregistry.ConnectedRegistryArgs.builder
import com.pulumi.azurenative.containerregistry.kotlin.enums.ConnectedRegistryMode
import com.pulumi.azurenative.containerregistry.kotlin.inputs.LoggingPropertiesArgs
import com.pulumi.azurenative.containerregistry.kotlin.inputs.LoggingPropertiesArgsBuilder
import com.pulumi.azurenative.containerregistry.kotlin.inputs.ParentPropertiesArgs
import com.pulumi.azurenative.containerregistry.kotlin.inputs.ParentPropertiesArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * An object that represents a connected registry for a container registry.
 * Azure REST API version: 2023-01-01-preview. Prior API version in Azure Native 1.x: 2020-11-01-preview.
 * Other available API versions: 2023-06-01-preview, 2023-08-01-preview, 2023-11-01-preview.
 * ## Example Usage
 * ### ConnectedRegistryCreate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var connectedRegistry = new AzureNative.ContainerRegistry.ConnectedRegistry("connectedRegistry", new()
 *     {
 *         ClientTokenIds = new[]
 *         {
 *             "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myResourceGroup/providers/Microsoft.ContainerRegistry/registries/myRegistry/tokens/client1Token",
 *         },
 *         ConnectedRegistryName = "myConnectedRegistry",
 *         Mode = "ReadWrite",
 *         NotificationsList = new[]
 *         {
 *             "hello-world:*:*",
 *             "sample/repo/*:1.0:*",
 *         },
 *         Parent = new AzureNative.ContainerRegistry.Inputs.ParentPropertiesArgs
 *         {
 *             SyncProperties = new AzureNative.ContainerRegistry.Inputs.SyncPropertiesArgs
 *             {
 *                 MessageTtl = "P2D",
 *                 Schedule = "0 9 * * *",
 *                 SyncWindow = "PT3H",
 *                 TokenId = "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myResourceGroup/providers/Microsoft.ContainerRegistry/registries/myRegistry/tokens/syncToken",
 *             },
 *         },
 *         RegistryName = "myRegistry",
 *         ResourceGroupName = "myResourceGroup",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/containerregistry/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := containerregistry.NewConnectedRegistry(ctx, "connectedRegistry", &containerregistry.ConnectedRegistryArgs{
 * 			ClientTokenIds: pulumi.StringArray{
 * 				pulumi.String("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myResourceGroup/providers/Microsoft.ContainerRegistry/registries/myRegistry/tokens/client1Token"),
 * 			},
 * 			ConnectedRegistryName: pulumi.String("myConnectedRegistry"),
 * 			Mode:                  pulumi.String("ReadWrite"),
 * 			NotificationsList: pulumi.StringArray{
 * 				pulumi.String("hello-world:*:*"),
 * 				pulumi.String("sample/repo/*:1.0:*"),
 * 			},
 * 			Parent: containerregistry.ParentPropertiesResponse{
 * 				SyncProperties: &containerregistry.SyncPropertiesArgs{
 * 					MessageTtl: pulumi.String("P2D"),
 * 					Schedule:   pulumi.String("0 9 * * *"),
 * 					SyncWindow: pulumi.String("PT3H"),
 * 					TokenId:    pulumi.String("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myResourceGroup/providers/Microsoft.ContainerRegistry/registries/myRegistry/tokens/syncToken"),
 * 				},
 * 			},
 * 			RegistryName:      pulumi.String("myRegistry"),
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.containerregistry.ConnectedRegistry;
 * import com.pulumi.azurenative.containerregistry.ConnectedRegistryArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var connectedRegistry = new ConnectedRegistry("connectedRegistry", ConnectedRegistryArgs.builder()
 *             .clientTokenIds("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myResourceGroup/providers/Microsoft.ContainerRegistry/registries/myRegistry/tokens/client1Token")
 *             .connectedRegistryName("myConnectedRegistry")
 *             .mode("ReadWrite")
 *             .notificationsList(
 *                 "hello-world:*:*",
 *                 "sample/repo/*:1.0:*")
 *             .parent(Map.of("syncProperties", Map.ofEntries(
 *                 Map.entry("messageTtl", "P2D"),
 *                 Map.entry("schedule", "0 9 * * *"),
 *                 Map.entry("syncWindow", "PT3H"),
 *                 Map.entry("tokenId", "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myResourceGroup/providers/Microsoft.ContainerRegistry/registries/myRegistry/tokens/syncToken")
 *             )))
 *             .registryName("myRegistry")
 *             .resourceGroupName("myResourceGroup")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:containerregistry:ConnectedRegistry myConnectedRegistry /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerRegistry/registries/{registryName}/connectedRegistries/{connectedRegistryName}
 * ```
 * @property clientTokenIds The list of the ACR token resource IDs used to authenticate clients to the connected registry.
 * @property connectedRegistryName The name of the connected registry.
 * @property logging The logging properties of the connected registry.
 * @property mode The mode of the connected registry resource that indicates the permissions of the registry.
 * @property notificationsList The list of notifications subscription information for the connected registry.
 * @property parent The parent of the connected registry.
 * @property registryName The name of the container registry.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * */*/*/
 */
public data class ConnectedRegistryArgs(
    public val clientTokenIds: Output<List<String>>? = null,
    public val connectedRegistryName: Output<String>? = null,
    public val logging: Output<LoggingPropertiesArgs>? = null,
    public val mode: Output<Either<String, ConnectedRegistryMode>>? = null,
    public val notificationsList: Output<List<String>>? = null,
    public val parent: Output<ParentPropertiesArgs>? = null,
    public val registryName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.containerregistry.ConnectedRegistryArgs> {
    override fun toJava(): com.pulumi.azurenative.containerregistry.ConnectedRegistryArgs =
        com.pulumi.azurenative.containerregistry.ConnectedRegistryArgs.builder()
            .clientTokenIds(clientTokenIds?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .connectedRegistryName(connectedRegistryName?.applyValue({ args0 -> args0 }))
            .logging(logging?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .mode(
                mode?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .notificationsList(notificationsList?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .parent(parent?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .registryName(registryName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ConnectedRegistryArgs].
 */
@PulumiTagMarker
public class ConnectedRegistryArgsBuilder internal constructor() {
    private var clientTokenIds: Output<List<String>>? = null

    private var connectedRegistryName: Output<String>? = null

    private var logging: Output<LoggingPropertiesArgs>? = null

    private var mode: Output<Either<String, ConnectedRegistryMode>>? = null

    private var notificationsList: Output<List<String>>? = null

    private var parent: Output<ParentPropertiesArgs>? = null

    private var registryName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    /**
     * @param value The list of the ACR token resource IDs used to authenticate clients to the connected registry.
     */
    @JvmName("pqunvfdlakeogscr")
    public suspend fun clientTokenIds(`value`: Output<List<String>>) {
        this.clientTokenIds = value
    }

    @JvmName("hsjhbglqqfceokpx")
    public suspend fun clientTokenIds(vararg values: Output<String>) {
        this.clientTokenIds = Output.all(values.asList())
    }

    /**
     * @param values The list of the ACR token resource IDs used to authenticate clients to the connected registry.
     */
    @JvmName("modfwiftorbjxpav")
    public suspend fun clientTokenIds(values: List<Output<String>>) {
        this.clientTokenIds = Output.all(values)
    }

    /**
     * @param value The name of the connected registry.
     */
    @JvmName("qcpvkifsdhyuisja")
    public suspend fun connectedRegistryName(`value`: Output<String>) {
        this.connectedRegistryName = value
    }

    /**
     * @param value The logging properties of the connected registry.
     */
    @JvmName("jnrpinqjetiswfug")
    public suspend fun logging(`value`: Output<LoggingPropertiesArgs>) {
        this.logging = value
    }

    /**
     * @param value The mode of the connected registry resource that indicates the permissions of the registry.
     */
    @JvmName("wesxwpcturtynutv")
    public suspend fun mode(`value`: Output<Either<String, ConnectedRegistryMode>>) {
        this.mode = value
    }

    /**
     * @param value The list of notifications subscription information for the connected registry.
     */
    @JvmName("xscqdbhpynechifm")
    public suspend fun notificationsList(`value`: Output<List<String>>) {
        this.notificationsList = value
    }

    @JvmName("iahtsllqbctmekkr")
    public suspend fun notificationsList(vararg values: Output<String>) {
        this.notificationsList = Output.all(values.asList())
    }

    /**
     * @param values The list of notifications subscription information for the connected registry.
     */
    @JvmName("ihxrpqmjuuucvecn")
    public suspend fun notificationsList(values: List<Output<String>>) {
        this.notificationsList = Output.all(values)
    }

    /**
     * @param value The parent of the connected registry.
     */
    @JvmName("akrftavdpgekfkhy")
    public suspend fun parent(`value`: Output<ParentPropertiesArgs>) {
        this.parent = value
    }

    /**
     * @param value The name of the container registry.
     */
    @JvmName("wcatvndiivyyltor")
    public suspend fun registryName(`value`: Output<String>) {
        this.registryName = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("lkkantwkllycmebh")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The list of the ACR token resource IDs used to authenticate clients to the connected registry.
     */
    @JvmName("rnxfeamhcawqjbah")
    public suspend fun clientTokenIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clientTokenIds = mapped
    }

    /**
     * @param values The list of the ACR token resource IDs used to authenticate clients to the connected registry.
     */
    @JvmName("uokfrbpyqedtdqkg")
    public suspend fun clientTokenIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.clientTokenIds = mapped
    }

    /**
     * @param value The name of the connected registry.
     */
    @JvmName("yytarjcncktufewc")
    public suspend fun connectedRegistryName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.connectedRegistryName = mapped
    }

    /**
     * @param value The logging properties of the connected registry.
     */
    @JvmName("dfuwtdkrjjfsagpj")
    public suspend fun logging(`value`: LoggingPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.logging = mapped
    }

    /**
     * @param argument The logging properties of the connected registry.
     */
    @JvmName("jmqkntecqsmtbjea")
    public suspend fun logging(argument: suspend LoggingPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = LoggingPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.logging = mapped
    }

    /**
     * @param value The mode of the connected registry resource that indicates the permissions of the registry.
     */
    @JvmName("xqpruhmuwtlawknu")
    public suspend fun mode(`value`: Either<String, ConnectedRegistryMode>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mode = mapped
    }

    /**
     * @param value The mode of the connected registry resource that indicates the permissions of the registry.
     */
    @JvmName("kigwaxsabelqlyur")
    public fun mode(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ConnectedRegistryMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.mode = mapped
    }

    /**
     * @param value The mode of the connected registry resource that indicates the permissions of the registry.
     */
    @JvmName("vjbgpiaydcujagjn")
    public fun mode(`value`: ConnectedRegistryMode) {
        val toBeMapped = Either.ofRight<String, ConnectedRegistryMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.mode = mapped
    }

    /**
     * @param value The list of notifications subscription information for the connected registry.
     */
    @JvmName("raldsrlomiqkikxk")
    public suspend fun notificationsList(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.notificationsList = mapped
    }

    /**
     * @param values The list of notifications subscription information for the connected registry.
     */
    @JvmName("coeikqjfpugxayle")
    public suspend fun notificationsList(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.notificationsList = mapped
    }

    /**
     * @param value The parent of the connected registry.
     */
    @JvmName("rjoneswskbuauqxn")
    public suspend fun parent(`value`: ParentPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parent = mapped
    }

    /**
     * @param argument The parent of the connected registry.
     */
    @JvmName("fyjdtqftiuhuckvx")
    public suspend fun parent(argument: suspend ParentPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = ParentPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.parent = mapped
    }

    /**
     * @param value The name of the container registry.
     */
    @JvmName("jjupujdjjtxecjyd")
    public suspend fun registryName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.registryName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("tfkucfjpgvnstfyu")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    internal fun build(): ConnectedRegistryArgs = ConnectedRegistryArgs(
        clientTokenIds = clientTokenIds,
        connectedRegistryName = connectedRegistryName,
        logging = logging,
        mode = mode,
        notificationsList = notificationsList,
        parent = parent,
        registryName = registryName,
        resourceGroupName = resourceGroupName,
    )
}
