@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerregistry.kotlin

import com.pulumi.azurenative.containerregistry.kotlin.outputs.AuthCredentialResponse
import com.pulumi.azurenative.containerregistry.kotlin.outputs.IdentityPropertiesResponse
import com.pulumi.azurenative.containerregistry.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import com.pulumi.azurenative.containerregistry.kotlin.outputs.AuthCredentialResponse.Companion.toKotlin as authCredentialResponseToKotlin
import com.pulumi.azurenative.containerregistry.kotlin.outputs.IdentityPropertiesResponse.Companion.toKotlin as identityPropertiesResponseToKotlin
import com.pulumi.azurenative.containerregistry.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [CredentialSet].
 */
@PulumiTagMarker
public class CredentialSetResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: CredentialSetArgs = CredentialSetArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend CredentialSetArgsBuilder.() -> Unit) {
        val builder = CredentialSetArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): CredentialSet {
        val builtJavaResource =
            com.pulumi.azurenative.containerregistry.CredentialSet(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return CredentialSet(builtJavaResource)
    }
}

/**
 * An object that represents a credential set resource for a container registry.
 * Azure REST API version: 2023-01-01-preview.
 * Other available API versions: 2023-06-01-preview, 2023-07-01, 2023-08-01-preview, 2023-11-01-preview.
 * ## Example Usage
 * ### CredentialSetCreate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var credentialSet = new AzureNative.ContainerRegistry.CredentialSet("credentialSet", new()
 *     {
 *         AuthCredentials = new[]
 *         {
 *             new AzureNative.ContainerRegistry.Inputs.AuthCredentialArgs
 *             {
 *                 Name = "Credential1",
 *                 PasswordSecretIdentifier = "https://myvault.vault.azure.net/secrets/password",
 *                 UsernameSecretIdentifier = "https://myvault.vault.azure.net/secrets/username",
 *             },
 *         },
 *         CredentialSetName = "myCredentialSet",
 *         Identity = new AzureNative.ContainerRegistry.Inputs.IdentityPropertiesArgs
 *         {
 *             Type = AzureNative.ContainerRegistry.ResourceIdentityType.SystemAssigned,
 *         },
 *         LoginServer = "docker.io",
 *         RegistryName = "myRegistry",
 *         ResourceGroupName = "myResourceGroup",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/containerregistry/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := containerregistry.NewCredentialSet(ctx, "credentialSet", &containerregistry.CredentialSetArgs{
 * 			AuthCredentials: []containerregistry.AuthCredentialArgs{
 * 				{
 * 					Name:                     pulumi.String("Credential1"),
 * 					PasswordSecretIdentifier: pulumi.String("https://myvault.vault.azure.net/secrets/password"),
 * 					UsernameSecretIdentifier: pulumi.String("https://myvault.vault.azure.net/secrets/username"),
 * 				},
 * 			},
 * 			CredentialSetName: pulumi.String("myCredentialSet"),
 * 			Identity: &containerregistry.IdentityPropertiesArgs{
 * 				Type: containerregistry.ResourceIdentityTypeSystemAssigned,
 * 			},
 * 			LoginServer:       pulumi.String("docker.io"),
 * 			RegistryName:      pulumi.String("myRegistry"),
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.containerregistry.CredentialSet;
 * import com.pulumi.azurenative.containerregistry.CredentialSetArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var credentialSet = new CredentialSet("credentialSet", CredentialSetArgs.builder()
 *             .authCredentials(Map.ofEntries(
 *                 Map.entry("name", "Credential1"),
 *                 Map.entry("passwordSecretIdentifier", "https://myvault.vault.azure.net/secrets/password"),
 *                 Map.entry("usernameSecretIdentifier", "https://myvault.vault.azure.net/secrets/username")
 *             ))
 *             .credentialSetName("myCredentialSet")
 *             .identity(Map.of("type", "SystemAssigned"))
 *             .loginServer("docker.io")
 *             .registryName("myRegistry")
 *             .resourceGroupName("myResourceGroup")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:containerregistry:CredentialSet myCredentialSet /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerRegistry/registries/{registryName}/credentialSets/{credentialSetName}
 * ```
 */
public class CredentialSet internal constructor(
    override val javaResource: com.pulumi.azurenative.containerregistry.CredentialSet,
) : KotlinCustomResource(javaResource, CredentialSetMapper) {
    /**
     * List of authentication credentials stored for an upstream.
     * Usually consists of a primary and an optional secondary credential.
     */
    public val authCredentials: Output<List<AuthCredentialResponse>>?
        get() = javaResource.authCredentials().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        authCredentialResponseToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * The creation date of credential store resource.
     */
    public val creationDate: Output<String>
        get() = javaResource.creationDate().applyValue({ args0 -> args0 })

    /**
     * Identities associated with the resource. This is used to access the KeyVault secrets.
     */
    public val identity: Output<IdentityPropertiesResponse>?
        get() = javaResource.identity().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    identityPropertiesResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The credentials are stored for this upstream or login server.
     */
    public val loginServer: Output<String>?
        get() = javaResource.loginServer().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name of the resource.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Provisioning state of the resource.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Metadata pertaining to creation and last modification of the resource.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * The type of the resource.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object CredentialSetMapper : ResourceMapper<CredentialSet> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.containerregistry.CredentialSet::class == javaResource::class

    override fun map(javaResource: Resource): CredentialSet = CredentialSet(
        javaResource as
            com.pulumi.azurenative.containerregistry.CredentialSet,
    )
}

/**
 * @see [CredentialSet].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [CredentialSet].
 */
public suspend fun credentialSet(
    name: String,
    block: suspend CredentialSetResourceBuilder.() -> Unit,
): CredentialSet {
    val builder = CredentialSetResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [CredentialSet].
 * @param name The _unique_ name of the resulting resource.
 */
public fun credentialSet(name: String): CredentialSet {
    val builder = CredentialSetResourceBuilder()
    builder.name(name)
    return builder.build()
}
