@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerregistry.kotlin

import com.pulumi.azurenative.containerregistry.CredentialSetArgs.builder
import com.pulumi.azurenative.containerregistry.kotlin.inputs.AuthCredentialArgs
import com.pulumi.azurenative.containerregistry.kotlin.inputs.AuthCredentialArgsBuilder
import com.pulumi.azurenative.containerregistry.kotlin.inputs.IdentityPropertiesArgs
import com.pulumi.azurenative.containerregistry.kotlin.inputs.IdentityPropertiesArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * An object that represents a credential set resource for a container registry.
 * Azure REST API version: 2023-01-01-preview.
 * Other available API versions: 2023-06-01-preview, 2023-07-01, 2023-08-01-preview, 2023-11-01-preview.
 * ## Example Usage
 * ### CredentialSetCreate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var credentialSet = new AzureNative.ContainerRegistry.CredentialSet("credentialSet", new()
 *     {
 *         AuthCredentials = new[]
 *         {
 *             new AzureNative.ContainerRegistry.Inputs.AuthCredentialArgs
 *             {
 *                 Name = "Credential1",
 *                 PasswordSecretIdentifier = "https://myvault.vault.azure.net/secrets/password",
 *                 UsernameSecretIdentifier = "https://myvault.vault.azure.net/secrets/username",
 *             },
 *         },
 *         CredentialSetName = "myCredentialSet",
 *         Identity = new AzureNative.ContainerRegistry.Inputs.IdentityPropertiesArgs
 *         {
 *             Type = AzureNative.ContainerRegistry.ResourceIdentityType.SystemAssigned,
 *         },
 *         LoginServer = "docker.io",
 *         RegistryName = "myRegistry",
 *         ResourceGroupName = "myResourceGroup",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/containerregistry/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := containerregistry.NewCredentialSet(ctx, "credentialSet", &containerregistry.CredentialSetArgs{
 * 			AuthCredentials: []containerregistry.AuthCredentialArgs{
 * 				{
 * 					Name:                     pulumi.String("Credential1"),
 * 					PasswordSecretIdentifier: pulumi.String("https://myvault.vault.azure.net/secrets/password"),
 * 					UsernameSecretIdentifier: pulumi.String("https://myvault.vault.azure.net/secrets/username"),
 * 				},
 * 			},
 * 			CredentialSetName: pulumi.String("myCredentialSet"),
 * 			Identity: &containerregistry.IdentityPropertiesArgs{
 * 				Type: containerregistry.ResourceIdentityTypeSystemAssigned,
 * 			},
 * 			LoginServer:       pulumi.String("docker.io"),
 * 			RegistryName:      pulumi.String("myRegistry"),
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.containerregistry.CredentialSet;
 * import com.pulumi.azurenative.containerregistry.CredentialSetArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var credentialSet = new CredentialSet("credentialSet", CredentialSetArgs.builder()
 *             .authCredentials(Map.ofEntries(
 *                 Map.entry("name", "Credential1"),
 *                 Map.entry("passwordSecretIdentifier", "https://myvault.vault.azure.net/secrets/password"),
 *                 Map.entry("usernameSecretIdentifier", "https://myvault.vault.azure.net/secrets/username")
 *             ))
 *             .credentialSetName("myCredentialSet")
 *             .identity(Map.of("type", "SystemAssigned"))
 *             .loginServer("docker.io")
 *             .registryName("myRegistry")
 *             .resourceGroupName("myResourceGroup")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:containerregistry:CredentialSet myCredentialSet /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerRegistry/registries/{registryName}/credentialSets/{credentialSetName}
 * ```
 * @property authCredentials List of authentication credentials stored for an upstream.
 * Usually consists of a primary and an optional secondary credential.
 * @property credentialSetName The name of the credential set.
 * @property identity Identities associated with the resource. This is used to access the KeyVault secrets.
 * @property loginServer The credentials are stored for this upstream or login server.
 * @property registryName The name of the container registry.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class CredentialSetArgs(
    public val authCredentials: Output<List<AuthCredentialArgs>>? = null,
    public val credentialSetName: Output<String>? = null,
    public val identity: Output<IdentityPropertiesArgs>? = null,
    public val loginServer: Output<String>? = null,
    public val registryName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.containerregistry.CredentialSetArgs> {
    override fun toJava(): com.pulumi.azurenative.containerregistry.CredentialSetArgs =
        com.pulumi.azurenative.containerregistry.CredentialSetArgs.builder()
            .authCredentials(
                authCredentials?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .credentialSetName(credentialSetName?.applyValue({ args0 -> args0 }))
            .identity(identity?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .loginServer(loginServer?.applyValue({ args0 -> args0 }))
            .registryName(registryName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [CredentialSetArgs].
 */
@PulumiTagMarker
public class CredentialSetArgsBuilder internal constructor() {
    private var authCredentials: Output<List<AuthCredentialArgs>>? = null

    private var credentialSetName: Output<String>? = null

    private var identity: Output<IdentityPropertiesArgs>? = null

    private var loginServer: Output<String>? = null

    private var registryName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    /**
     * @param value List of authentication credentials stored for an upstream.
     * Usually consists of a primary and an optional secondary credential.
     */
    @JvmName("oykjuvcjrvnfaxlx")
    public suspend fun authCredentials(`value`: Output<List<AuthCredentialArgs>>) {
        this.authCredentials = value
    }

    @JvmName("xcsovbuwivokclob")
    public suspend fun authCredentials(vararg values: Output<AuthCredentialArgs>) {
        this.authCredentials = Output.all(values.asList())
    }

    /**
     * @param values List of authentication credentials stored for an upstream.
     * Usually consists of a primary and an optional secondary credential.
     */
    @JvmName("lkfqiwbddomlmnow")
    public suspend fun authCredentials(values: List<Output<AuthCredentialArgs>>) {
        this.authCredentials = Output.all(values)
    }

    /**
     * @param value The name of the credential set.
     */
    @JvmName("jbxnqdvupbgmoloy")
    public suspend fun credentialSetName(`value`: Output<String>) {
        this.credentialSetName = value
    }

    /**
     * @param value Identities associated with the resource. This is used to access the KeyVault secrets.
     */
    @JvmName("qcjgomaduweytnma")
    public suspend fun identity(`value`: Output<IdentityPropertiesArgs>) {
        this.identity = value
    }

    /**
     * @param value The credentials are stored for this upstream or login server.
     */
    @JvmName("reaircugnqapirkl")
    public suspend fun loginServer(`value`: Output<String>) {
        this.loginServer = value
    }

    /**
     * @param value The name of the container registry.
     */
    @JvmName("xbgjwfpoafjgnyjq")
    public suspend fun registryName(`value`: Output<String>) {
        this.registryName = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("xocftlujoemgvsqe")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value List of authentication credentials stored for an upstream.
     * Usually consists of a primary and an optional secondary credential.
     */
    @JvmName("jxtaaipuybxrodwm")
    public suspend fun authCredentials(`value`: List<AuthCredentialArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.authCredentials = mapped
    }

    /**
     * @param argument List of authentication credentials stored for an upstream.
     * Usually consists of a primary and an optional secondary credential.
     */
    @JvmName("ibgqfynqtsicewbr")
    public suspend fun authCredentials(argument: List<suspend AuthCredentialArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            AuthCredentialArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.authCredentials = mapped
    }

    /**
     * @param argument List of authentication credentials stored for an upstream.
     * Usually consists of a primary and an optional secondary credential.
     */
    @JvmName("dbnpblvyfxtqqymv")
    public suspend fun authCredentials(
        vararg
        argument: suspend AuthCredentialArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            AuthCredentialArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.authCredentials = mapped
    }

    /**
     * @param argument List of authentication credentials stored for an upstream.
     * Usually consists of a primary and an optional secondary credential.
     */
    @JvmName("tmifvoykhuyfqqgv")
    public suspend fun authCredentials(argument: suspend AuthCredentialArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(AuthCredentialArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.authCredentials = mapped
    }

    /**
     * @param values List of authentication credentials stored for an upstream.
     * Usually consists of a primary and an optional secondary credential.
     */
    @JvmName("xetfgqigyienjscx")
    public suspend fun authCredentials(vararg values: AuthCredentialArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.authCredentials = mapped
    }

    /**
     * @param value The name of the credential set.
     */
    @JvmName("qpmgcnngodiofcbe")
    public suspend fun credentialSetName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.credentialSetName = mapped
    }

    /**
     * @param value Identities associated with the resource. This is used to access the KeyVault secrets.
     */
    @JvmName("ftdtcunrsjlvmuxx")
    public suspend fun identity(`value`: IdentityPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.identity = mapped
    }

    /**
     * @param argument Identities associated with the resource. This is used to access the KeyVault secrets.
     */
    @JvmName("ywusglyexobwpdvo")
    public suspend fun identity(argument: suspend IdentityPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = IdentityPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.identity = mapped
    }

    /**
     * @param value The credentials are stored for this upstream or login server.
     */
    @JvmName("qroaqwkqiioxtvsu")
    public suspend fun loginServer(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.loginServer = mapped
    }

    /**
     * @param value The name of the container registry.
     */
    @JvmName("flbbohejaifxxbrc")
    public suspend fun registryName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.registryName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("nvqxqmokpjvwifbg")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    internal fun build(): CredentialSetArgs = CredentialSetArgs(
        authCredentials = authCredentials,
        credentialSetName = credentialSetName,
        identity = identity,
        loginServer = loginServer,
        registryName = registryName,
        resourceGroupName = resourceGroupName,
    )
}
