@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerregistry.kotlin

import com.pulumi.azurenative.containerregistry.kotlin.outputs.ExportPipelineTargetPropertiesResponse
import com.pulumi.azurenative.containerregistry.kotlin.outputs.IdentityPropertiesResponse
import com.pulumi.azurenative.containerregistry.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import com.pulumi.azurenative.containerregistry.kotlin.outputs.ExportPipelineTargetPropertiesResponse.Companion.toKotlin as exportPipelineTargetPropertiesResponseToKotlin
import com.pulumi.azurenative.containerregistry.kotlin.outputs.IdentityPropertiesResponse.Companion.toKotlin as identityPropertiesResponseToKotlin
import com.pulumi.azurenative.containerregistry.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [ExportPipeline].
 */
@PulumiTagMarker
public class ExportPipelineResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ExportPipelineArgs = ExportPipelineArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ExportPipelineArgsBuilder.() -> Unit) {
        val builder = ExportPipelineArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): ExportPipeline {
        val builtJavaResource =
            com.pulumi.azurenative.containerregistry.ExportPipeline(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return ExportPipeline(builtJavaResource)
    }
}

/**
 * An object that represents an export pipeline for a container registry.
 * Azure REST API version: 2023-01-01-preview. Prior API version in Azure Native 1.x: 2020-11-01-preview.
 * Other available API versions: 2023-06-01-preview, 2023-08-01-preview, 2023-11-01-preview.
 * ## Example Usage
 * ### ExportPipelineCreate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var exportPipeline = new AzureNative.ContainerRegistry.ExportPipeline("exportPipeline", new()
 *     {
 *         ExportPipelineName = "myExportPipeline",
 *         Identity = new AzureNative.ContainerRegistry.Inputs.IdentityPropertiesArgs
 *         {
 *             Type = AzureNative.ContainerRegistry.ResourceIdentityType.SystemAssigned,
 *         },
 *         Location = "westus",
 *         Options = new[]
 *         {
 *             "OverwriteBlobs",
 *         },
 *         RegistryName = "myRegistry",
 *         ResourceGroupName = "myResourceGroup",
 *         Target = new AzureNative.ContainerRegistry.Inputs.ExportPipelineTargetPropertiesArgs
 *         {
 *             KeyVaultUri = "https://myvault.vault.azure.net/secrets/acrexportsas",
 *             Type = "AzureStorageBlobContainer",
 *             Uri = "https://accountname.blob.core.windows.net/containername",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/containerregistry/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := containerregistry.NewExportPipeline(ctx, "exportPipeline", &containerregistry.ExportPipelineArgs{
 * 			ExportPipelineName: pulumi.String("myExportPipeline"),
 * 			Identity: &containerregistry.IdentityPropertiesArgs{
 * 				Type: containerregistry.ResourceIdentityTypeSystemAssigned,
 * 			},
 * 			Location: pulumi.String("westus"),
 * 			Options: pulumi.StringArray{
 * 				pulumi.String("OverwriteBlobs"),
 * 			},
 * 			RegistryName:      pulumi.String("myRegistry"),
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			Target: &containerregistry.ExportPipelineTargetPropertiesArgs{
 * 				KeyVaultUri: pulumi.String("https://myvault.vault.azure.net/secrets/acrexportsas"),
 * 				Type:        pulumi.String("AzureStorageBlobContainer"),
 * 				Uri:         pulumi.String("https://accountname.blob.core.windows.net/containername"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.containerregistry.ExportPipeline;
 * import com.pulumi.azurenative.containerregistry.ExportPipelineArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exportPipeline = new ExportPipeline("exportPipeline", ExportPipelineArgs.builder()
 *             .exportPipelineName("myExportPipeline")
 *             .identity(Map.of("type", "SystemAssigned"))
 *             .location("westus")
 *             .options("OverwriteBlobs")
 *             .registryName("myRegistry")
 *             .resourceGroupName("myResourceGroup")
 *             .target(Map.ofEntries(
 *                 Map.entry("keyVaultUri", "https://myvault.vault.azure.net/secrets/acrexportsas"),
 *                 Map.entry("type", "AzureStorageBlobContainer"),
 *                 Map.entry("uri", "https://accountname.blob.core.windows.net/containername")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:containerregistry:ExportPipeline myExportPipeline /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerRegistry/registries/{registryName}/exportPipelines/{exportPipelineName}
 * ```
 */
public class ExportPipeline internal constructor(
    override val javaResource: com.pulumi.azurenative.containerregistry.ExportPipeline,
) : KotlinCustomResource(javaResource, ExportPipelineMapper) {
    /**
     * The identity of the export pipeline.
     */
    public val identity: Output<IdentityPropertiesResponse>?
        get() = javaResource.identity().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    identityPropertiesResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The location of the export pipeline.
     */
    public val location: Output<String>?
        get() = javaResource.location().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The name of the resource.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The list of all options configured for the pipeline.
     */
    public val options: Output<List<String>>?
        get() = javaResource.options().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0
                })
            }).orElse(null)
        })

    /**
     * The provisioning state of the pipeline at the time the operation was called.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Metadata pertaining to creation and last modification of the resource.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * The target properties of the export pipeline.
     */
    public val target: Output<ExportPipelineTargetPropertiesResponse>
        get() = javaResource.target().applyValue({ args0 ->
            args0.let({ args0 ->
                exportPipelineTargetPropertiesResponseToKotlin(args0)
            })
        })

    /**
     * The type of the resource.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object ExportPipelineMapper : ResourceMapper<ExportPipeline> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.containerregistry.ExportPipeline::class == javaResource::class

    override fun map(javaResource: Resource): ExportPipeline = ExportPipeline(
        javaResource as
            com.pulumi.azurenative.containerregistry.ExportPipeline,
    )
}

/**
 * @see [ExportPipeline].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ExportPipeline].
 */
public suspend fun exportPipeline(
    name: String,
    block: suspend ExportPipelineResourceBuilder.() -> Unit,
): ExportPipeline {
    val builder = ExportPipelineResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ExportPipeline].
 * @param name The _unique_ name of the resulting resource.
 */
public fun exportPipeline(name: String): ExportPipeline {
    val builder = ExportPipelineResourceBuilder()
    builder.name(name)
    return builder.build()
}
