@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerregistry.kotlin

import com.pulumi.azurenative.containerregistry.TaskArgs.builder
import com.pulumi.azurenative.containerregistry.kotlin.enums.TaskStatus
import com.pulumi.azurenative.containerregistry.kotlin.inputs.AgentPropertiesArgs
import com.pulumi.azurenative.containerregistry.kotlin.inputs.AgentPropertiesArgsBuilder
import com.pulumi.azurenative.containerregistry.kotlin.inputs.CredentialsArgs
import com.pulumi.azurenative.containerregistry.kotlin.inputs.CredentialsArgsBuilder
import com.pulumi.azurenative.containerregistry.kotlin.inputs.IdentityPropertiesArgs
import com.pulumi.azurenative.containerregistry.kotlin.inputs.IdentityPropertiesArgsBuilder
import com.pulumi.azurenative.containerregistry.kotlin.inputs.PlatformPropertiesArgs
import com.pulumi.azurenative.containerregistry.kotlin.inputs.PlatformPropertiesArgsBuilder
import com.pulumi.azurenative.containerregistry.kotlin.inputs.TriggerPropertiesArgs
import com.pulumi.azurenative.containerregistry.kotlin.inputs.TriggerPropertiesArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Any
import kotlin.Boolean
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * The task that has the ARM resource and task properties.
 * The task will have all information to schedule a run against it.
 * Azure REST API version: 2019-06-01-preview. Prior API version in Azure Native 1.x: 2019-06-01-preview.
 * Other available API versions: 2018-09-01, 2019-04-01.
 * ## Example Usage
 * ### Tasks_Create
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var task = new AzureNative.ContainerRegistry.Task("task", new()
 *     {
 *         AgentConfiguration = new AzureNative.ContainerRegistry.Inputs.AgentPropertiesArgs
 *         {
 *             Cpu = 2,
 *         },
 *         Identity = new AzureNative.ContainerRegistry.Inputs.IdentityPropertiesArgs
 *         {
 *             Type = AzureNative.ContainerRegistry.ResourceIdentityType.SystemAssigned,
 *         },
 *         IsSystemTask = false,
 *         Location = "eastus",
 *         LogTemplate = "acr/tasks:{{.Run.OS}}",
 *         Platform = new AzureNative.ContainerRegistry.Inputs.PlatformPropertiesArgs
 *         {
 *             Architecture = "amd64",
 *             Os = "Linux",
 *         },
 *         RegistryName = "myRegistry",
 *         ResourceGroupName = "myResourceGroup",
 *         Status = "Enabled",
 *         Step = new AzureNative.ContainerRegistry.Inputs.DockerBuildStepArgs
 *         {
 *             Arguments = new[]
 *             {
 *                 new AzureNative.ContainerRegistry.Inputs.ArgumentArgs
 *                 {
 *                     IsSecret = false,
 *                     Name = "mytestargument",
 *                     Value = "mytestvalue",
 *                 },
 *                 new AzureNative.ContainerRegistry.Inputs.ArgumentArgs
 *                 {
 *                     IsSecret = true,
 *                     Name = "mysecrettestargument",
 *                     Value = "mysecrettestvalue",
 *                 },
 *             },
 *             ContextPath = "src",
 *             DockerFilePath = "src/DockerFile",
 *             ImageNames = new[]
 *             {
 *                 "azurerest:testtag",
 *             },
 *             IsPushEnabled = true,
 *             NoCache = false,
 *             Type = "Docker",
 *         },
 *         Tags =
 *         {
 *             { "testkey", "value" },
 *         },
 *         TaskName = "mytTask",
 *         Trigger = new AzureNative.ContainerRegistry.Inputs.TriggerPropertiesArgs
 *         {
 *             BaseImageTrigger = new AzureNative.ContainerRegistry.Inputs.BaseImageTriggerArgs
 *             {
 *                 BaseImageTriggerType = "Runtime",
 *                 Name = "myBaseImageTrigger",
 *                 UpdateTriggerEndpoint = "https://user:pass@mycicd.webhook.com?token=foo",
 *                 UpdateTriggerPayloadType = "Token",
 *             },
 *             SourceTriggers = new[]
 *             {
 *                 new AzureNative.ContainerRegistry.Inputs.SourceTriggerArgs
 *                 {
 *                     Name = "mySourceTrigger",
 *                     SourceRepository = new AzureNative.ContainerRegistry.Inputs.SourcePropertiesArgs
 *                     {
 *                         Branch = "master",
 *                         RepositoryUrl = "https://github.com/Azure/azure-rest-api-specs",
 *                         SourceControlAuthProperties = new AzureNative.ContainerRegistry.Inputs.AuthInfoArgs
 *                         {
 *                             Token = "xxxxx",
 *                             TokenType = "PAT",
 *                         },
 *                         SourceControlType = "Github",
 *                     },
 *                     SourceTriggerEvents = new[]
 *                     {
 *                         "commit",
 *                     },
 *                 },
 *             },
 *             TimerTriggers = new[]
 *             {
 *                 new AzureNative.ContainerRegistry.Inputs.TimerTriggerArgs
 *                 {
 *                     Name = "myTimerTrigger",
 *                     Schedule = "30 9 * * 1-5",
 *                 },
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/containerregistry/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := containerregistry.NewTask(ctx, "task", &containerregistry.TaskArgs{
 * AgentConfiguration: &containerregistry.AgentPropertiesArgs{
 * Cpu: pulumi.Int(2),
 * },
 * Identity: &containerregistry.IdentityPropertiesArgs{
 * Type: containerregistry.ResourceIdentityTypeSystemAssigned,
 * },
 * IsSystemTask: pulumi.Bool(false),
 * Location: pulumi.String("eastus"),
 * LogTemplate: pulumi.String("acr/tasks:{{.Run.OS}}"),
 * Platform: &containerregistry.PlatformPropertiesArgs{
 * Architecture: pulumi.String("amd64"),
 * Os: pulumi.String("Linux"),
 * },
 * RegistryName: pulumi.String("myRegistry"),
 * ResourceGroupName: pulumi.String("myResourceGroup"),
 * Status: pulumi.String("Enabled"),
 * Step: containerregistry.DockerBuildStep{
 * Arguments: []containerregistry.Argument{
 * {
 * IsSecret: false,
 * Name: "mytestargument",
 * Value: "mytestvalue",
 * },
 * {
 * IsSecret: true,
 * Name: "mysecrettestargument",
 * Value: "mysecrettestvalue",
 * },
 * },
 * ContextPath: "src",
 * DockerFilePath: "src/DockerFile",
 * ImageNames: []string{
 * "azurerest:testtag",
 * },
 * IsPushEnabled: true,
 * NoCache: false,
 * Type: "Docker",
 * },
 * Tags: pulumi.StringMap{
 * "testkey": pulumi.String("value"),
 * },
 * TaskName: pulumi.String("mytTask"),
 * Trigger: containerregistry.TriggerPropertiesResponse{
 * BaseImageTrigger: &containerregistry.BaseImageTriggerArgs{
 * BaseImageTriggerType: pulumi.String("Runtime"),
 * Name: pulumi.String("myBaseImageTrigger"),
 * UpdateTriggerEndpoint: pulumi.String("https://user:pass@mycicd.webhook.com?token=foo"),
 * UpdateTriggerPayloadType: pulumi.String("Token"),
 * },
 * SourceTriggers: containerregistry.SourceTriggerArray{
 * interface{}{
 * Name: pulumi.String("mySourceTrigger"),
 * SourceRepository: interface{}{
 * Branch: pulumi.String("master"),
 * RepositoryUrl: pulumi.String("https://github.com/Azure/azure-rest-api-specs"),
 * SourceControlAuthProperties: &containerregistry.AuthInfoArgs{
 * Token: pulumi.String("xxxxx"),
 * TokenType: pulumi.String("PAT"),
 * },
 * SourceControlType: pulumi.String("Github"),
 * },
 * SourceTriggerEvents: pulumi.StringArray{
 * pulumi.String("commit"),
 * },
 * },
 * },
 * TimerTriggers: containerregistry.TimerTriggerArray{
 * &containerregistry.TimerTriggerArgs{
 * Name: pulumi.String("myTimerTrigger"),
 * Schedule: pulumi.String("30 9 * * 1-5"),
 * },
 * },
 * },
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.containerregistry.Task;
 * import com.pulumi.azurenative.containerregistry.TaskArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var task = new Task("task", TaskArgs.builder()
 *             .agentConfiguration(Map.of("cpu", 2))
 *             .identity(Map.of("type", "SystemAssigned"))
 *             .isSystemTask(false)
 *             .location("eastus")
 *             .logTemplate("acr/tasks:{{.Run.OS}}")
 *             .platform(Map.ofEntries(
 *                 Map.entry("architecture", "amd64"),
 *                 Map.entry("os", "Linux")
 *             ))
 *             .registryName("myRegistry")
 *             .resourceGroupName("myResourceGroup")
 *             .status("Enabled")
 *             .step(Map.ofEntries(
 *                 Map.entry("arguments",
 *                     Map.ofEntries(
 *                         Map.entry("isSecret", false),
 *                         Map.entry("name", "mytestargument"),
 *                         Map.entry("value", "mytestvalue")
 *                     ),
 *                     Map.ofEntries(
 *                         Map.entry("isSecret", true),
 *                         Map.entry("name", "mysecrettestargument"),
 *                         Map.entry("value", "mysecrettestvalue")
 *                     )),
 *                 Map.entry("contextPath", "src"),
 *                 Map.entry("dockerFilePath", "src/DockerFile"),
 *                 Map.entry("imageNames", "azurerest:testtag"),
 *                 Map.entry("isPushEnabled", true),
 *                 Map.entry("noCache", false),
 *                 Map.entry("type", "Docker")
 *             ))
 *             .tags(Map.of("testkey", "value"))
 *             .taskName("mytTask")
 *             .trigger(Map.ofEntries(
 *                 Map.entry("baseImageTrigger", Map.ofEntries(
 *                     Map.entry("baseImageTriggerType", "Runtime"),
 *                     Map.entry("name", "myBaseImageTrigger"),
 *                     Map.entry("updateTriggerEndpoint", "https://user:pass@mycicd.webhook.com?token=foo"),
 *                     Map.entry("updateTriggerPayloadType", "Token")
 *                 )),
 *                 Map.entry("sourceTriggers", Map.ofEntries(
 *                     Map.entry("name", "mySourceTrigger"),
 *                     Map.entry("sourceRepository", Map.ofEntries(
 *                         Map.entry("branch", "master"),
 *                         Map.entry("repositoryUrl", "https://github.com/Azure/azure-rest-api-specs"),
 *                         Map.entry("sourceControlAuthProperties", Map.ofEntries(
 *                             Map.entry("token", "xxxxx"),
 *                             Map.entry("tokenType", "PAT")
 *                         )),
 *                         Map.entry("sourceControlType", "Github")
 *                     )),
 *                     Map.entry("sourceTriggerEvents", "commit")
 *                 )),
 *                 Map.entry("timerTriggers", Map.ofEntries(
 *                     Map.entry("name", "myTimerTrigger"),
 *                     Map.entry("schedule", "30 9 * * 1-5")
 *                 ))
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ### Tasks_Create_QuickTask
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var task = new AzureNative.ContainerRegistry.Task("task", new()
 *     {
 *         IsSystemTask = true,
 *         Location = "eastus",
 *         LogTemplate = "acr/tasks:{{.Run.OS}}",
 *         RegistryName = "myRegistry",
 *         ResourceGroupName = "myResourceGroup",
 *         Status = "Enabled",
 *         Tags =
 *         {
 *             { "testkey", "value" },
 *         },
 *         TaskName = "quicktask",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/containerregistry/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := containerregistry.NewTask(ctx, "task", &containerregistry.TaskArgs{
 * 			IsSystemTask:      pulumi.Bool(true),
 * 			Location:          pulumi.String("eastus"),
 * 			LogTemplate:       pulumi.String("acr/tasks:{{.Run.OS}}"),
 * 			RegistryName:      pulumi.String("myRegistry"),
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			Status:            pulumi.String("Enabled"),
 * 			Tags: pulumi.StringMap{
 * 				"testkey": pulumi.String("value"),
 * 			},
 * 			TaskName: pulumi.String("quicktask"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.containerregistry.Task;
 * import com.pulumi.azurenative.containerregistry.TaskArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var task = new Task("task", TaskArgs.builder()
 *             .isSystemTask(true)
 *             .location("eastus")
 *             .logTemplate("acr/tasks:{{.Run.OS}}")
 *             .registryName("myRegistry")
 *             .resourceGroupName("myResourceGroup")
 *             .status("Enabled")
 *             .tags(Map.of("testkey", "value"))
 *             .taskName("quicktask")
 *             .build());
 *     }
 * }
 * ```
 * ### Tasks_Create_WithSystemAndUserIdentities
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var task = new AzureNative.ContainerRegistry.Task("task", new()
 *     {
 *         AgentConfiguration = new AzureNative.ContainerRegistry.Inputs.AgentPropertiesArgs
 *         {
 *             Cpu = 2,
 *         },
 *         Identity = new AzureNative.ContainerRegistry.Inputs.IdentityPropertiesArgs
 *         {
 *             Type = AzureNative.ContainerRegistry.ResourceIdentityType.SystemAssigned_UserAssigned,
 *             UserAssignedIdentities =
 *             {
 *                 { "/subscriptions/f9d7ebed-adbd-4cb4-b973-aaf82c136138/resourcegroups/myResourceGroup1/providers/Microsoft.ManagedIdentity/userAssignedIdentities/identity2", null },
 *             },
 *         },
 *         IsSystemTask = false,
 *         Location = "eastus",
 *         Platform = new AzureNative.ContainerRegistry.Inputs.PlatformPropertiesArgs
 *         {
 *             Architecture = "amd64",
 *             Os = "Linux",
 *         },
 *         RegistryName = "myRegistry",
 *         ResourceGroupName = "myResourceGroup",
 *         Status = "Enabled",
 *         Step = new AzureNative.ContainerRegistry.Inputs.DockerBuildStepArgs
 *         {
 *             Arguments = new[]
 *             {
 *                 new AzureNative.ContainerRegistry.Inputs.ArgumentArgs
 *                 {
 *                     IsSecret = false,
 *                     Name = "mytestargument",
 *                     Value = "mytestvalue",
 *                 },
 *                 new AzureNative.ContainerRegistry.Inputs.ArgumentArgs
 *                 {
 *                     IsSecret = true,
 *                     Name = "mysecrettestargument",
 *                     Value = "mysecrettestvalue",
 *                 },
 *             },
 *             ContextPath = "src",
 *             DockerFilePath = "src/DockerFile",
 *             ImageNames = new[]
 *             {
 *                 "azurerest:testtag",
 *             },
 *             IsPushEnabled = true,
 *             NoCache = false,
 *             Type = "Docker",
 *         },
 *         Tags =
 *         {
 *             { "testkey", "value" },
 *         },
 *         TaskName = "mytTask",
 *         Trigger = new AzureNative.ContainerRegistry.Inputs.TriggerPropertiesArgs
 *         {
 *             BaseImageTrigger = new AzureNative.ContainerRegistry.Inputs.BaseImageTriggerArgs
 *             {
 *                 BaseImageTriggerType = "Runtime",
 *                 Name = "myBaseImageTrigger",
 *                 UpdateTriggerEndpoint = "https://user:pass@mycicd.webhook.com?token=foo",
 *                 UpdateTriggerPayloadType = "Default",
 *             },
 *             SourceTriggers = new[]
 *             {
 *                 new AzureNative.ContainerRegistry.Inputs.SourceTriggerArgs
 *                 {
 *                     Name = "mySourceTrigger",
 *                     SourceRepository = new AzureNative.ContainerRegistry.Inputs.SourcePropertiesArgs
 *                     {
 *                         Branch = "master",
 *                         RepositoryUrl = "https://github.com/Azure/azure-rest-api-specs",
 *                         SourceControlAuthProperties = new AzureNative.ContainerRegistry.Inputs.AuthInfoArgs
 *                         {
 *                             Token = "xxxxx",
 *                             TokenType = "PAT",
 *                         },
 *                         SourceControlType = "Github",
 *                     },
 *                     SourceTriggerEvents = new[]
 *                     {
 *                         "commit",
 *                     },
 *                 },
 *             },
 *             TimerTriggers = new[]
 *             {
 *                 new AzureNative.ContainerRegistry.Inputs.TimerTriggerArgs
 *                 {
 *                     Name = "myTimerTrigger",
 *                     Schedule = "30 9 * * 1-5",
 *                 },
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/containerregistry/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := containerregistry.NewTask(ctx, "task", &containerregistry.TaskArgs{
 * AgentConfiguration: &containerregistry.AgentPropertiesArgs{
 * Cpu: pulumi.Int(2),
 * },
 * Identity: containerregistry.IdentityPropertiesResponse{
 * Type: containerregistry.ResourceIdentityType_SystemAssigned_UserAssigned,
 * UserAssignedIdentities: containerregistry.UserIdentityPropertiesMap{
 * "/subscriptions/f9d7ebed-adbd-4cb4-b973-aaf82c136138/resourcegroups/myResourceGroup1/providers/Microsoft.ManagedIdentity/userAssignedIdentities/identity2": nil,
 * },
 * },
 * IsSystemTask: pulumi.Bool(false),
 * Location: pulumi.String("eastus"),
 * Platform: &containerregistry.PlatformPropertiesArgs{
 * Architecture: pulumi.String("amd64"),
 * Os: pulumi.String("Linux"),
 * },
 * RegistryName: pulumi.String("myRegistry"),
 * ResourceGroupName: pulumi.String("myResourceGroup"),
 * Status: pulumi.String("Enabled"),
 * Step: containerregistry.DockerBuildStep{
 * Arguments: []containerregistry.Argument{
 * {
 * IsSecret: false,
 * Name: "mytestargument",
 * Value: "mytestvalue",
 * },
 * {
 * IsSecret: true,
 * Name: "mysecrettestargument",
 * Value: "mysecrettestvalue",
 * },
 * },
 * ContextPath: "src",
 * DockerFilePath: "src/DockerFile",
 * ImageNames: []string{
 * "azurerest:testtag",
 * },
 * IsPushEnabled: true,
 * NoCache: false,
 * Type: "Docker",
 * },
 * Tags: pulumi.StringMap{
 * "testkey": pulumi.String("value"),
 * },
 * TaskName: pulumi.String("mytTask"),
 * Trigger: containerregistry.TriggerPropertiesResponse{
 * BaseImageTrigger: &containerregistry.BaseImageTriggerArgs{
 * BaseImageTriggerType: pulumi.String("Runtime"),
 * Name: pulumi.String("myBaseImageTrigger"),
 * UpdateTriggerEndpoint: pulumi.String("https://user:pass@mycicd.webhook.com?token=foo"),
 * UpdateTriggerPayloadType: pulumi.String("Default"),
 * },
 * SourceTriggers: containerregistry.SourceTriggerArray{
 * interface{}{
 * Name: pulumi.String("mySourceTrigger"),
 * SourceRepository: interface{}{
 * Branch: pulumi.String("master"),
 * RepositoryUrl: pulumi.String("https://github.com/Azure/azure-rest-api-specs"),
 * SourceControlAuthProperties: &containerregistry.AuthInfoArgs{
 * Token: pulumi.String("xxxxx"),
 * TokenType: pulumi.String("PAT"),
 * },
 * SourceControlType: pulumi.String("Github"),
 * },
 * SourceTriggerEvents: pulumi.StringArray{
 * pulumi.String("commit"),
 * },
 * },
 * },
 * TimerTriggers: containerregistry.TimerTriggerArray{
 * &containerregistry.TimerTriggerArgs{
 * Name: pulumi.String("myTimerTrigger"),
 * Schedule: pulumi.String("30 9 * * 1-5"),
 * },
 * },
 * },
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.containerregistry.Task;
 * import com.pulumi.azurenative.containerregistry.TaskArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var task = new Task("task", TaskArgs.builder()
 *             .agentConfiguration(Map.of("cpu", 2))
 *             .identity(Map.ofEntries(
 *                 Map.entry("type", "SystemAssigned, UserAssigned"),
 *                 Map.entry("userAssignedIdentities", Map.of("/subscriptions/f9d7ebed-adbd-4cb4-b973-aaf82c136138/resourcegroups/myResourceGroup1/providers/Microsoft.ManagedIdentity/userAssignedIdentities/identity2", ))
 *             ))
 *             .isSystemTask(false)
 *             .location("eastus")
 *             .platform(Map.ofEntries(
 *                 Map.entry("architecture", "amd64"),
 *                 Map.entry("os", "Linux")
 *             ))
 *             .registryName("myRegistry")
 *             .resourceGroupName("myResourceGroup")
 *             .status("Enabled")
 *             .step(Map.ofEntries(
 *                 Map.entry("arguments",
 *                     Map.ofEntries(
 *                         Map.entry("isSecret", false),
 *                         Map.entry("name", "mytestargument"),
 *                         Map.entry("value", "mytestvalue")
 *                     ),
 *                     Map.ofEntries(
 *                         Map.entry("isSecret", true),
 *                         Map.entry("name", "mysecrettestargument"),
 *                         Map.entry("value", "mysecrettestvalue")
 *                     )),
 *                 Map.entry("contextPath", "src"),
 *                 Map.entry("dockerFilePath", "src/DockerFile"),
 *                 Map.entry("imageNames", "azurerest:testtag"),
 *                 Map.entry("isPushEnabled", true),
 *                 Map.entry("noCache", false),
 *                 Map.entry("type", "Docker")
 *             ))
 *             .tags(Map.of("testkey", "value"))
 *             .taskName("mytTask")
 *             .trigger(Map.ofEntries(
 *                 Map.entry("baseImageTrigger", Map.ofEntries(
 *                     Map.entry("baseImageTriggerType", "Runtime"),
 *                     Map.entry("name", "myBaseImageTrigger"),
 *                     Map.entry("updateTriggerEndpoint", "https://user:pass@mycicd.webhook.com?token=foo"),
 *                     Map.entry("updateTriggerPayloadType", "Default")
 *                 )),
 *                 Map.entry("sourceTriggers", Map.ofEntries(
 *                     Map.entry("name", "mySourceTrigger"),
 *                     Map.entry("sourceRepository", Map.ofEntries(
 *                         Map.entry("branch", "master"),
 *                         Map.entry("repositoryUrl", "https://github.com/Azure/azure-rest-api-specs"),
 *                         Map.entry("sourceControlAuthProperties", Map.ofEntries(
 *                             Map.entry("token", "xxxxx"),
 *                             Map.entry("tokenType", "PAT")
 *                         )),
 *                         Map.entry("sourceControlType", "Github")
 *                     )),
 *                     Map.entry("sourceTriggerEvents", "commit")
 *                 )),
 *                 Map.entry("timerTriggers", Map.ofEntries(
 *                     Map.entry("name", "myTimerTrigger"),
 *                     Map.entry("schedule", "30 9 * * 1-5")
 *                 ))
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ### Tasks_Create_WithUserIdentities
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var task = new AzureNative.ContainerRegistry.Task("task", new()
 *     {
 *         AgentConfiguration = new AzureNative.ContainerRegistry.Inputs.AgentPropertiesArgs
 *         {
 *             Cpu = 2,
 *         },
 *         Identity = new AzureNative.ContainerRegistry.Inputs.IdentityPropertiesArgs
 *         {
 *             Type = AzureNative.ContainerRegistry.ResourceIdentityType.UserAssigned,
 *             UserAssignedIdentities =
 *             {
 *                 { "/subscriptions/f9d7ebed-adbd-4cb4-b973-aaf82c136138/resourcegroups/myResourceGroup/providers/Microsoft.ManagedIdentity/userAssignedIdentities/identity1", null },
 *                 { "/subscriptions/f9d7ebed-adbd-4cb4-b973-aaf82c136138/resourcegroups/myResourceGroup1/providers/Microsoft.ManagedIdentity/userAssignedIdentities/identity2", null },
 *             },
 *         },
 *         IsSystemTask = false,
 *         Location = "eastus",
 *         Platform = new AzureNative.ContainerRegistry.Inputs.PlatformPropertiesArgs
 *         {
 *             Architecture = "amd64",
 *             Os = "Linux",
 *         },
 *         RegistryName = "myRegistry",
 *         ResourceGroupName = "myResourceGroup",
 *         Status = "Enabled",
 *         Step = new AzureNative.ContainerRegistry.Inputs.DockerBuildStepArgs
 *         {
 *             Arguments = new[]
 *             {
 *                 new AzureNative.ContainerRegistry.Inputs.ArgumentArgs
 *                 {
 *                     IsSecret = false,
 *                     Name = "mytestargument",
 *                     Value = "mytestvalue",
 *                 },
 *                 new AzureNative.ContainerRegistry.Inputs.ArgumentArgs
 *                 {
 *                     IsSecret = true,
 *                     Name = "mysecrettestargument",
 *                     Value = "mysecrettestvalue",
 *                 },
 *             },
 *             ContextPath = "src",
 *             DockerFilePath = "src/DockerFile",
 *             ImageNames = new[]
 *             {
 *                 "azurerest:testtag",
 *             },
 *             IsPushEnabled = true,
 *             NoCache = false,
 *             Type = "Docker",
 *         },
 *         Tags =
 *         {
 *             { "testkey", "value" },
 *         },
 *         TaskName = "mytTask",
 *         Trigger = new AzureNative.ContainerRegistry.Inputs.TriggerPropertiesArgs
 *         {
 *             BaseImageTrigger = new AzureNative.ContainerRegistry.Inputs.BaseImageTriggerArgs
 *             {
 *                 BaseImageTriggerType = "Runtime",
 *                 Name = "myBaseImageTrigger",
 *                 UpdateTriggerEndpoint = "https://user:pass@mycicd.webhook.com?token=foo",
 *                 UpdateTriggerPayloadType = "Default",
 *             },
 *             SourceTriggers = new[]
 *             {
 *                 new AzureNative.ContainerRegistry.Inputs.SourceTriggerArgs
 *                 {
 *                     Name = "mySourceTrigger",
 *                     SourceRepository = new AzureNative.ContainerRegistry.Inputs.SourcePropertiesArgs
 *                     {
 *                         Branch = "master",
 *                         RepositoryUrl = "https://github.com/Azure/azure-rest-api-specs",
 *                         SourceControlAuthProperties = new AzureNative.ContainerRegistry.Inputs.AuthInfoArgs
 *                         {
 *                             Token = "xxxxx",
 *                             TokenType = "PAT",
 *                         },
 *                         SourceControlType = "Github",
 *                     },
 *                     SourceTriggerEvents = new[]
 *                     {
 *                         "commit",
 *                     },
 *                 },
 *             },
 *             TimerTriggers = new[]
 *             {
 *                 new AzureNative.ContainerRegistry.Inputs.TimerTriggerArgs
 *                 {
 *                     Name = "myTimerTrigger",
 *                     Schedule = "30 9 * * 1-5",
 *                 },
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/containerregistry/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := containerregistry.NewTask(ctx, "task", &containerregistry.TaskArgs{
 * AgentConfiguration: &containerregistry.AgentPropertiesArgs{
 * Cpu: pulumi.Int(2),
 * },
 * Identity: containerregistry.IdentityPropertiesResponse{
 * Type: containerregistry.ResourceIdentityTypeUserAssigned,
 * UserAssignedIdentities: containerregistry.UserIdentityPropertiesMap{
 * "/subscriptions/f9d7ebed-adbd-4cb4-b973-aaf82c136138/resourcegroups/myResourceGroup/providers/Microsoft.ManagedIdentity/userAssignedIdentities/identity1": nil,
 * "/subscriptions/f9d7ebed-adbd-4cb4-b973-aaf82c136138/resourcegroups/myResourceGroup1/providers/Microsoft.ManagedIdentity/userAssignedIdentities/identity2": nil,
 * },
 * },
 * IsSystemTask: pulumi.Bool(false),
 * Location: pulumi.String("eastus"),
 * Platform: &containerregistry.PlatformPropertiesArgs{
 * Architecture: pulumi.String("amd64"),
 * Os: pulumi.String("Linux"),
 * },
 * RegistryName: pulumi.String("myRegistry"),
 * ResourceGroupName: pulumi.String("myResourceGroup"),
 * Status: pulumi.String("Enabled"),
 * Step: containerregistry.DockerBuildStep{
 * Arguments: []containerregistry.Argument{
 * {
 * IsSecret: false,
 * Name: "mytestargument",
 * Value: "mytestvalue",
 * },
 * {
 * IsSecret: true,
 * Name: "mysecrettestargument",
 * Value: "mysecrettestvalue",
 * },
 * },
 * ContextPath: "src",
 * DockerFilePath: "src/DockerFile",
 * ImageNames: []string{
 * "azurerest:testtag",
 * },
 * IsPushEnabled: true,
 * NoCache: false,
 * Type: "Docker",
 * },
 * Tags: pulumi.StringMap{
 * "testkey": pulumi.String("value"),
 * },
 * TaskName: pulumi.String("mytTask"),
 * Trigger: containerregistry.TriggerPropertiesResponse{
 * BaseImageTrigger: &containerregistry.BaseImageTriggerArgs{
 * BaseImageTriggerType: pulumi.String("Runtime"),
 * Name: pulumi.String("myBaseImageTrigger"),
 * UpdateTriggerEndpoint: pulumi.String("https://user:pass@mycicd.webhook.com?token=foo"),
 * UpdateTriggerPayloadType: pulumi.String("Default"),
 * },
 * SourceTriggers: containerregistry.SourceTriggerArray{
 * interface{}{
 * Name: pulumi.String("mySourceTrigger"),
 * SourceRepository: interface{}{
 * Branch: pulumi.String("master"),
 * RepositoryUrl: pulumi.String("https://github.com/Azure/azure-rest-api-specs"),
 * SourceControlAuthProperties: &containerregistry.AuthInfoArgs{
 * Token: pulumi.String("xxxxx"),
 * TokenType: pulumi.String("PAT"),
 * },
 * SourceControlType: pulumi.String("Github"),
 * },
 * SourceTriggerEvents: pulumi.StringArray{
 * pulumi.String("commit"),
 * },
 * },
 * },
 * TimerTriggers: containerregistry.TimerTriggerArray{
 * &containerregistry.TimerTriggerArgs{
 * Name: pulumi.String("myTimerTrigger"),
 * Schedule: pulumi.String("30 9 * * 1-5"),
 * },
 * },
 * },
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.containerregistry.Task;
 * import com.pulumi.azurenative.containerregistry.TaskArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var task = new Task("task", TaskArgs.builder()
 *             .agentConfiguration(Map.of("cpu", 2))
 *             .identity(Map.ofEntries(
 *                 Map.entry("type", "UserAssigned"),
 *                 Map.entry("userAssignedIdentities", Map.ofEntries(
 *                     Map.entry("/subscriptions/f9d7ebed-adbd-4cb4-b973-aaf82c136138/resourcegroups/myResourceGroup/providers/Microsoft.ManagedIdentity/userAssignedIdentities/identity1", ),
 *                     Map.entry("/subscriptions/f9d7ebed-adbd-4cb4-b973-aaf82c136138/resourcegroups/myResourceGroup1/providers/Microsoft.ManagedIdentity/userAssignedIdentities/identity2", )
 *                 ))
 *             ))
 *             .isSystemTask(false)
 *             .location("eastus")
 *             .platform(Map.ofEntries(
 *                 Map.entry("architecture", "amd64"),
 *                 Map.entry("os", "Linux")
 *             ))
 *             .registryName("myRegistry")
 *             .resourceGroupName("myResourceGroup")
 *             .status("Enabled")
 *             .step(Map.ofEntries(
 *                 Map.entry("arguments",
 *                     Map.ofEntries(
 *                         Map.entry("isSecret", false),
 *                         Map.entry("name", "mytestargument"),
 *                         Map.entry("value", "mytestvalue")
 *                     ),
 *                     Map.ofEntries(
 *                         Map.entry("isSecret", true),
 *                         Map.entry("name", "mysecrettestargument"),
 *                         Map.entry("value", "mysecrettestvalue")
 *                     )),
 *                 Map.entry("contextPath", "src"),
 *                 Map.entry("dockerFilePath", "src/DockerFile"),
 *                 Map.entry("imageNames", "azurerest:testtag"),
 *                 Map.entry("isPushEnabled", true),
 *                 Map.entry("noCache", false),
 *                 Map.entry("type", "Docker")
 *             ))
 *             .tags(Map.of("testkey", "value"))
 *             .taskName("mytTask")
 *             .trigger(Map.ofEntries(
 *                 Map.entry("baseImageTrigger", Map.ofEntries(
 *                     Map.entry("baseImageTriggerType", "Runtime"),
 *                     Map.entry("name", "myBaseImageTrigger"),
 *                     Map.entry("updateTriggerEndpoint", "https://user:pass@mycicd.webhook.com?token=foo"),
 *                     Map.entry("updateTriggerPayloadType", "Default")
 *                 )),
 *                 Map.entry("sourceTriggers", Map.ofEntries(
 *                     Map.entry("name", "mySourceTrigger"),
 *                     Map.entry("sourceRepository", Map.ofEntries(
 *                         Map.entry("branch", "master"),
 *                         Map.entry("repositoryUrl", "https://github.com/Azure/azure-rest-api-specs"),
 *                         Map.entry("sourceControlAuthProperties", Map.ofEntries(
 *                             Map.entry("token", "xxxxx"),
 *                             Map.entry("tokenType", "PAT")
 *                         )),
 *                         Map.entry("sourceControlType", "Github")
 *                     )),
 *                     Map.entry("sourceTriggerEvents", "commit")
 *                 )),
 *                 Map.entry("timerTriggers", Map.ofEntries(
 *                     Map.entry("name", "myTimerTrigger"),
 *                     Map.entry("schedule", "30 9 * * 1-5")
 *                 ))
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ### Tasks_Create_WithUserIdentities_WithSystemIdentity
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var task = new AzureNative.ContainerRegistry.Task("task", new()
 *     {
 *         AgentConfiguration = new AzureNative.ContainerRegistry.Inputs.AgentPropertiesArgs
 *         {
 *             Cpu = 2,
 *         },
 *         Identity = new AzureNative.ContainerRegistry.Inputs.IdentityPropertiesArgs
 *         {
 *             Type = AzureNative.ContainerRegistry.ResourceIdentityType.SystemAssigned,
 *         },
 *         IsSystemTask = false,
 *         Location = "eastus",
 *         Platform = new AzureNative.ContainerRegistry.Inputs.PlatformPropertiesArgs
 *         {
 *             Architecture = "amd64",
 *             Os = "Linux",
 *         },
 *         RegistryName = "myRegistry",
 *         ResourceGroupName = "myResourceGroup",
 *         Status = "Enabled",
 *         Step = new AzureNative.ContainerRegistry.Inputs.DockerBuildStepArgs
 *         {
 *             Arguments = new[]
 *             {
 *                 new AzureNative.ContainerRegistry.Inputs.ArgumentArgs
 *                 {
 *                     IsSecret = false,
 *                     Name = "mytestargument",
 *                     Value = "mytestvalue",
 *                 },
 *                 new AzureNative.ContainerRegistry.Inputs.ArgumentArgs
 *                 {
 *                     IsSecret = true,
 *                     Name = "mysecrettestargument",
 *                     Value = "mysecrettestvalue",
 *                 },
 *             },
 *             ContextPath = "src",
 *             DockerFilePath = "src/DockerFile",
 *             ImageNames = new[]
 *             {
 *                 "azurerest:testtag",
 *             },
 *             IsPushEnabled = true,
 *             NoCache = false,
 *             Type = "Docker",
 *         },
 *         Tags =
 *         {
 *             { "testkey", "value" },
 *         },
 *         TaskName = "mytTask",
 *         Trigger = new AzureNative.ContainerRegistry.Inputs.TriggerPropertiesArgs
 *         {
 *             BaseImageTrigger = new AzureNative.ContainerRegistry.Inputs.BaseImageTriggerArgs
 *             {
 *                 BaseImageTriggerType = "Runtime",
 *                 Name = "myBaseImageTrigger",
 *             },
 *             SourceTriggers = new[]
 *             {
 *                 new AzureNative.ContainerRegistry.Inputs.SourceTriggerArgs
 *                 {
 *                     Name = "mySourceTrigger",
 *                     SourceRepository = new AzureNative.ContainerRegistry.Inputs.SourcePropertiesArgs
 *                     {
 *                         Branch = "master",
 *                         RepositoryUrl = "https://github.com/Azure/azure-rest-api-specs",
 *                         SourceControlAuthProperties = new AzureNative.ContainerRegistry.Inputs.AuthInfoArgs
 *                         {
 *                             Token = "xxxxx",
 *                             TokenType = "PAT",
 *                         },
 *                         SourceControlType = "Github",
 *                     },
 *                     SourceTriggerEvents = new[]
 *                     {
 *                         "commit",
 *                     },
 *                 },
 *             },
 *             TimerTriggers = new[]
 *             {
 *                 new AzureNative.ContainerRegistry.Inputs.TimerTriggerArgs
 *                 {
 *                     Name = "myTimerTrigger",
 *                     Schedule = "30 9 * * 1-5",
 *                 },
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/containerregistry/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := containerregistry.NewTask(ctx, "task", &containerregistry.TaskArgs{
 * AgentConfiguration: &containerregistry.AgentPropertiesArgs{
 * Cpu: pulumi.Int(2),
 * },
 * Identity: &containerregistry.IdentityPropertiesArgs{
 * Type: containerregistry.ResourceIdentityTypeSystemAssigned,
 * },
 * IsSystemTask: pulumi.Bool(false),
 * Location: pulumi.String("eastus"),
 * Platform: &containerregistry.PlatformPropertiesArgs{
 * Architecture: pulumi.String("amd64"),
 * Os: pulumi.String("Linux"),
 * },
 * RegistryName: pulumi.String("myRegistry"),
 * ResourceGroupName: pulumi.String("myResourceGroup"),
 * Status: pulumi.String("Enabled"),
 * Step: containerregistry.DockerBuildStep{
 * Arguments: []containerregistry.Argument{
 * {
 * IsSecret: false,
 * Name: "mytestargument",
 * Value: "mytestvalue",
 * },
 * {
 * IsSecret: true,
 * Name: "mysecrettestargument",
 * Value: "mysecrettestvalue",
 * },
 * },
 * ContextPath: "src",
 * DockerFilePath: "src/DockerFile",
 * ImageNames: []string{
 * "azurerest:testtag",
 * },
 * IsPushEnabled: true,
 * NoCache: false,
 * Type: "Docker",
 * },
 * Tags: pulumi.StringMap{
 * "testkey": pulumi.String("value"),
 * },
 * TaskName: pulumi.String("mytTask"),
 * Trigger: containerregistry.TriggerPropertiesResponse{
 * BaseImageTrigger: &containerregistry.BaseImageTriggerArgs{
 * BaseImageTriggerType: pulumi.String("Runtime"),
 * Name: pulumi.String("myBaseImageTrigger"),
 * },
 * SourceTriggers: containerregistry.SourceTriggerArray{
 * interface{}{
 * Name: pulumi.String("mySourceTrigger"),
 * SourceRepository: interface{}{
 * Branch: pulumi.String("master"),
 * RepositoryUrl: pulumi.String("https://github.com/Azure/azure-rest-api-specs"),
 * SourceControlAuthProperties: &containerregistry.AuthInfoArgs{
 * Token: pulumi.String("xxxxx"),
 * TokenType: pulumi.String("PAT"),
 * },
 * SourceControlType: pulumi.String("Github"),
 * },
 * SourceTriggerEvents: pulumi.StringArray{
 * pulumi.String("commit"),
 * },
 * },
 * },
 * TimerTriggers: containerregistry.TimerTriggerArray{
 * &containerregistry.TimerTriggerArgs{
 * Name: pulumi.String("myTimerTrigger"),
 * Schedule: pulumi.String("30 9 * * 1-5"),
 * },
 * },
 * },
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.containerregistry.Task;
 * import com.pulumi.azurenative.containerregistry.TaskArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var task = new Task("task", TaskArgs.builder()
 *             .agentConfiguration(Map.of("cpu", 2))
 *             .identity(Map.of("type", "SystemAssigned"))
 *             .isSystemTask(false)
 *             .location("eastus")
 *             .platform(Map.ofEntries(
 *                 Map.entry("architecture", "amd64"),
 *                 Map.entry("os", "Linux")
 *             ))
 *             .registryName("myRegistry")
 *             .resourceGroupName("myResourceGroup")
 *             .status("Enabled")
 *             .step(Map.ofEntries(
 *                 Map.entry("arguments",
 *                     Map.ofEntries(
 *                         Map.entry("isSecret", false),
 *                         Map.entry("name", "mytestargument"),
 *                         Map.entry("value", "mytestvalue")
 *                     ),
 *                     Map.ofEntries(
 *                         Map.entry("isSecret", true),
 *                         Map.entry("name", "mysecrettestargument"),
 *                         Map.entry("value", "mysecrettestvalue")
 *                     )),
 *                 Map.entry("contextPath", "src"),
 *                 Map.entry("dockerFilePath", "src/DockerFile"),
 *                 Map.entry("imageNames", "azurerest:testtag"),
 *                 Map.entry("isPushEnabled", true),
 *                 Map.entry("noCache", false),
 *                 Map.entry("type", "Docker")
 *             ))
 *             .tags(Map.of("testkey", "value"))
 *             .taskName("mytTask")
 *             .trigger(Map.ofEntries(
 *                 Map.entry("baseImageTrigger", Map.ofEntries(
 *                     Map.entry("baseImageTriggerType", "Runtime"),
 *                     Map.entry("name", "myBaseImageTrigger")
 *                 )),
 *                 Map.entry("sourceTriggers", Map.ofEntries(
 *                     Map.entry("name", "mySourceTrigger"),
 *                     Map.entry("sourceRepository", Map.ofEntries(
 *                         Map.entry("branch", "master"),
 *                         Map.entry("repositoryUrl", "https://github.com/Azure/azure-rest-api-specs"),
 *                         Map.entry("sourceControlAuthProperties", Map.ofEntries(
 *                             Map.entry("token", "xxxxx"),
 *                             Map.entry("tokenType", "PAT")
 *                         )),
 *                         Map.entry("sourceControlType", "Github")
 *                     )),
 *                     Map.entry("sourceTriggerEvents", "commit")
 *                 )),
 *                 Map.entry("timerTriggers", Map.ofEntries(
 *                     Map.entry("name", "myTimerTrigger"),
 *                     Map.entry("schedule", "30 9 * * 1-5")
 *                 ))
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:containerregistry:Task myTask /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerRegistry/registries/{registryName}/tasks/{taskName}
 * ```
 * @property agentConfiguration The machine configuration of the run agent.
 * @property agentPoolName The dedicated agent pool for the task.
 * @property credentials The properties that describes a set of credentials that will be used when this run is invoked.
 * @property identity Identity for the resource.
 * @property isSystemTask The value of this property indicates whether the task resource is system task or not.
 * @property location The location of the resource. This cannot be changed after the resource is created.
 * @property logTemplate The template that describes the repository and tag information for run log artifact.
 * @property platform The platform properties against which the run has to happen.
 * @property registryName The name of the container registry.
 * @property resourceGroupName The name of the resource group to which the container registry belongs.
 * @property status The current status of task.
 * @property step The properties of a task step.
 * @property tags The tags of the resource.
 * @property taskName The name of the container registry task.
 * @property timeout Run timeout in seconds.
 * @property trigger The properties that describe all triggers for the task.
 */
public data class TaskArgs(
    public val agentConfiguration: Output<AgentPropertiesArgs>? = null,
    public val agentPoolName: Output<String>? = null,
    public val credentials: Output<CredentialsArgs>? = null,
    public val identity: Output<IdentityPropertiesArgs>? = null,
    public val isSystemTask: Output<Boolean>? = null,
    public val location: Output<String>? = null,
    public val logTemplate: Output<String>? = null,
    public val platform: Output<PlatformPropertiesArgs>? = null,
    public val registryName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val status: Output<Either<String, TaskStatus>>? = null,
    public val step: Output<Any>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val taskName: Output<String>? = null,
    public val timeout: Output<Int>? = null,
    public val trigger: Output<TriggerPropertiesArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.containerregistry.TaskArgs> {
    override fun toJava(): com.pulumi.azurenative.containerregistry.TaskArgs =
        com.pulumi.azurenative.containerregistry.TaskArgs.builder()
            .agentConfiguration(
                agentConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .agentPoolName(agentPoolName?.applyValue({ args0 -> args0 }))
            .credentials(credentials?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .identity(identity?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .isSystemTask(isSystemTask?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .logTemplate(logTemplate?.applyValue({ args0 -> args0 }))
            .platform(platform?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .registryName(registryName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .status(
                status?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .step(step?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .taskName(taskName?.applyValue({ args0 -> args0 }))
            .timeout(timeout?.applyValue({ args0 -> args0 }))
            .trigger(trigger?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [TaskArgs].
 */
@PulumiTagMarker
public class TaskArgsBuilder internal constructor() {
    private var agentConfiguration: Output<AgentPropertiesArgs>? = null

    private var agentPoolName: Output<String>? = null

    private var credentials: Output<CredentialsArgs>? = null

    private var identity: Output<IdentityPropertiesArgs>? = null

    private var isSystemTask: Output<Boolean>? = null

    private var location: Output<String>? = null

    private var logTemplate: Output<String>? = null

    private var platform: Output<PlatformPropertiesArgs>? = null

    private var registryName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var status: Output<Either<String, TaskStatus>>? = null

    private var step: Output<Any>? = null

    private var tags: Output<Map<String, String>>? = null

    private var taskName: Output<String>? = null

    private var timeout: Output<Int>? = null

    private var trigger: Output<TriggerPropertiesArgs>? = null

    /**
     * @param value The machine configuration of the run agent.
     */
    @JvmName("ukjpvcuafqpplluf")
    public suspend fun agentConfiguration(`value`: Output<AgentPropertiesArgs>) {
        this.agentConfiguration = value
    }

    /**
     * @param value The dedicated agent pool for the task.
     */
    @JvmName("lfvivntvnvwofctw")
    public suspend fun agentPoolName(`value`: Output<String>) {
        this.agentPoolName = value
    }

    /**
     * @param value The properties that describes a set of credentials that will be used when this run is invoked.
     */
    @JvmName("xiftedkxcpuvnjbw")
    public suspend fun credentials(`value`: Output<CredentialsArgs>) {
        this.credentials = value
    }

    /**
     * @param value Identity for the resource.
     */
    @JvmName("fivpatrwxdkrvobd")
    public suspend fun identity(`value`: Output<IdentityPropertiesArgs>) {
        this.identity = value
    }

    /**
     * @param value The value of this property indicates whether the task resource is system task or not.
     */
    @JvmName("hrnfroodbycrihgr")
    public suspend fun isSystemTask(`value`: Output<Boolean>) {
        this.isSystemTask = value
    }

    /**
     * @param value The location of the resource. This cannot be changed after the resource is created.
     */
    @JvmName("gqgjxvbbathfqlps")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The template that describes the repository and tag information for run log artifact.
     */
    @JvmName("ijivcjtsnwgpakub")
    public suspend fun logTemplate(`value`: Output<String>) {
        this.logTemplate = value
    }

    /**
     * @param value The platform properties against which the run has to happen.
     */
    @JvmName("bybqqgssuhypmmhq")
    public suspend fun platform(`value`: Output<PlatformPropertiesArgs>) {
        this.platform = value
    }

    /**
     * @param value The name of the container registry.
     */
    @JvmName("gcldedqqlhbjqmpq")
    public suspend fun registryName(`value`: Output<String>) {
        this.registryName = value
    }

    /**
     * @param value The name of the resource group to which the container registry belongs.
     */
    @JvmName("pevttqaxvtywgnoy")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The current status of task.
     */
    @JvmName("qfodupwcmqperkjt")
    public suspend fun status(`value`: Output<Either<String, TaskStatus>>) {
        this.status = value
    }

    /**
     * @param value The properties of a task step.
     */
    @JvmName("peuovbadknkjfuik")
    public suspend fun step(`value`: Output<Any>) {
        this.step = value
    }

    /**
     * @param value The tags of the resource.
     */
    @JvmName("faumqpogdoofojoo")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The name of the container registry task.
     */
    @JvmName("ouovpoylywsvkeex")
    public suspend fun taskName(`value`: Output<String>) {
        this.taskName = value
    }

    /**
     * @param value Run timeout in seconds.
     */
    @JvmName("igxdxjichylakytm")
    public suspend fun timeout(`value`: Output<Int>) {
        this.timeout = value
    }

    /**
     * @param value The properties that describe all triggers for the task.
     */
    @JvmName("ubpykmxyytdgfhpx")
    public suspend fun trigger(`value`: Output<TriggerPropertiesArgs>) {
        this.trigger = value
    }

    /**
     * @param value The machine configuration of the run agent.
     */
    @JvmName("dxlskhbvuvaaavgk")
    public suspend fun agentConfiguration(`value`: AgentPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.agentConfiguration = mapped
    }

    /**
     * @param argument The machine configuration of the run agent.
     */
    @JvmName("njllkewghbvjjacm")
    public suspend fun agentConfiguration(argument: suspend AgentPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = AgentPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.agentConfiguration = mapped
    }

    /**
     * @param value The dedicated agent pool for the task.
     */
    @JvmName("pdoehacrbaocmngb")
    public suspend fun agentPoolName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.agentPoolName = mapped
    }

    /**
     * @param value The properties that describes a set of credentials that will be used when this run is invoked.
     */
    @JvmName("sxppeyegcwnlkcgo")
    public suspend fun credentials(`value`: CredentialsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.credentials = mapped
    }

    /**
     * @param argument The properties that describes a set of credentials that will be used when this run is invoked.
     */
    @JvmName("hojrwviwwurcvklk")
    public suspend fun credentials(argument: suspend CredentialsArgsBuilder.() -> Unit) {
        val toBeMapped = CredentialsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.credentials = mapped
    }

    /**
     * @param value Identity for the resource.
     */
    @JvmName("qpuirvjyuyywcqiy")
    public suspend fun identity(`value`: IdentityPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.identity = mapped
    }

    /**
     * @param argument Identity for the resource.
     */
    @JvmName("vdsitieifujiraeo")
    public suspend fun identity(argument: suspend IdentityPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = IdentityPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.identity = mapped
    }

    /**
     * @param value The value of this property indicates whether the task resource is system task or not.
     */
    @JvmName("bdnygrjghjiqwkin")
    public suspend fun isSystemTask(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isSystemTask = mapped
    }

    /**
     * @param value The location of the resource. This cannot be changed after the resource is created.
     */
    @JvmName("fnyfkgrdvpnnobra")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The template that describes the repository and tag information for run log artifact.
     */
    @JvmName("njskyvbjjswhdpar")
    public suspend fun logTemplate(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.logTemplate = mapped
    }

    /**
     * @param value The platform properties against which the run has to happen.
     */
    @JvmName("yxvtxeuerfdpgvbk")
    public suspend fun platform(`value`: PlatformPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.platform = mapped
    }

    /**
     * @param argument The platform properties against which the run has to happen.
     */
    @JvmName("wcohyeorluttpumt")
    public suspend fun platform(argument: suspend PlatformPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = PlatformPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.platform = mapped
    }

    /**
     * @param value The name of the container registry.
     */
    @JvmName("apljrcotrbfttvtd")
    public suspend fun registryName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.registryName = mapped
    }

    /**
     * @param value The name of the resource group to which the container registry belongs.
     */
    @JvmName("gwrrmuaxwlempulx")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The current status of task.
     */
    @JvmName("boytksovlbdttabw")
    public suspend fun status(`value`: Either<String, TaskStatus>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.status = mapped
    }

    /**
     * @param value The current status of task.
     */
    @JvmName("yvbpijceskhwaels")
    public fun status(`value`: String) {
        val toBeMapped = Either.ofLeft<String, TaskStatus>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.status = mapped
    }

    /**
     * @param value The current status of task.
     */
    @JvmName("jjqoueylggkufbcu")
    public fun status(`value`: TaskStatus) {
        val toBeMapped = Either.ofRight<String, TaskStatus>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.status = mapped
    }

    /**
     * @param value The properties of a task step.
     */
    @JvmName("ieuomjhfahdkrboy")
    public suspend fun step(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.step = mapped
    }

    /**
     * @param value The tags of the resource.
     */
    @JvmName("rmoweiirhnhgaubw")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values The tags of the resource.
     */
    @JvmName("howkengobpvbwubk")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The name of the container registry task.
     */
    @JvmName("fuorboueapeuwhpo")
    public suspend fun taskName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.taskName = mapped
    }

    /**
     * @param value Run timeout in seconds.
     */
    @JvmName("dooouetsjbdbefix")
    public suspend fun timeout(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timeout = mapped
    }

    /**
     * @param value The properties that describe all triggers for the task.
     */
    @JvmName("yhwcjtpeckhrnvoi")
    public suspend fun trigger(`value`: TriggerPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.trigger = mapped
    }

    /**
     * @param argument The properties that describe all triggers for the task.
     */
    @JvmName("brkpmwjtdbfkawqc")
    public suspend fun trigger(argument: suspend TriggerPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = TriggerPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.trigger = mapped
    }

    internal fun build(): TaskArgs = TaskArgs(
        agentConfiguration = agentConfiguration,
        agentPoolName = agentPoolName,
        credentials = credentials,
        identity = identity,
        isSystemTask = isSystemTask,
        location = location,
        logTemplate = logTemplate,
        platform = platform,
        registryName = registryName,
        resourceGroupName = resourceGroupName,
        status = status,
        step = step,
        tags = tags,
        taskName = taskName,
        timeout = timeout,
        trigger = trigger,
    )
}
