@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerregistry.kotlin

import com.pulumi.azurenative.containerregistry.kotlin.outputs.IdentityPropertiesResponse
import com.pulumi.azurenative.containerregistry.kotlin.outputs.RunResponse
import com.pulumi.azurenative.containerregistry.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Any
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.containerregistry.kotlin.outputs.IdentityPropertiesResponse.Companion.toKotlin as identityPropertiesResponseToKotlin
import com.pulumi.azurenative.containerregistry.kotlin.outputs.RunResponse.Companion.toKotlin as runResponseToKotlin
import com.pulumi.azurenative.containerregistry.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [TaskRun].
 */
@PulumiTagMarker
public class TaskRunResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: TaskRunArgs = TaskRunArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend TaskRunArgsBuilder.() -> Unit) {
        val builder = TaskRunArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): TaskRun {
        val builtJavaResource =
            com.pulumi.azurenative.containerregistry.TaskRun(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return TaskRun(builtJavaResource)
    }
}

/**
 * The task run that has the ARM resource and properties.
 * The task run will have the information of request and result of a run.
 * Azure REST API version: 2019-06-01-preview. Prior API version in Azure Native 1.x: 2019-06-01-preview.
 * ## Example Usage
 * ### TaskRuns_Create
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var taskRun = new AzureNative.ContainerRegistry.TaskRun("taskRun", new()
 *     {
 *         ForceUpdateTag = "test",
 *         RegistryName = "myRegistry",
 *         ResourceGroupName = "myResourceGroup",
 *         RunRequest = new AzureNative.ContainerRegistry.Inputs.EncodedTaskRunRequestArgs
 *         {
 *             Credentials = null,
 *             EncodedTaskContent = "c3RlcHM6IAogIC0gY21kOiB7eyAuVmFsdWVzLmNvbW1hbmQgfX0K",
 *             EncodedValuesContent = "Y29tbWFuZDogYmFzaCBlY2hvIHt7LlJ1bi5SZWdpc3RyeX19Cg==",
 *             Platform = new AzureNative.ContainerRegistry.Inputs.PlatformPropertiesArgs
 *             {
 *                 Architecture = "amd64",
 *                 Os = "Linux",
 *             },
 *             Type = "EncodedTaskRunRequest",
 *             Values = new() { },
 *         },
 *         TaskRunName = "myRun",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/containerregistry/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := containerregistry.NewTaskRun(ctx, "taskRun", &containerregistry.TaskRunArgs{
 * 			ForceUpdateTag:    pulumi.String("test"),
 * 			RegistryName:      pulumi.String("myRegistry"),
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			RunRequest: containerregistry.EncodedTaskRunRequest{
 * 				Credentials:          nil,
 * 				EncodedTaskContent:   "c3RlcHM6IAogIC0gY21kOiB7eyAuVmFsdWVzLmNvbW1hbmQgfX0K",
 * 				EncodedValuesContent: "Y29tbWFuZDogYmFzaCBlY2hvIHt7LlJ1bi5SZWdpc3RyeX19Cg==",
 * 				Platform: containerregistry.PlatformProperties{
 * 					Architecture: "amd64",
 * 					Os:           "Linux",
 * 				},
 * 				Type:   "EncodedTaskRunRequest",
 * 				Values: []containerregistry.SetValue{},
 * 			},
 * 			TaskRunName: pulumi.String("myRun"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.containerregistry.TaskRun;
 * import com.pulumi.azurenative.containerregistry.TaskRunArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var taskRun = new TaskRun("taskRun", TaskRunArgs.builder()
 *             .forceUpdateTag("test")
 *             .registryName("myRegistry")
 *             .resourceGroupName("myResourceGroup")
 *             .runRequest(Map.ofEntries(
 *                 Map.entry("credentials", ),
 *                 Map.entry("encodedTaskContent", "c3RlcHM6IAogIC0gY21kOiB7eyAuVmFsdWVzLmNvbW1hbmQgfX0K"),
 *                 Map.entry("encodedValuesContent", "Y29tbWFuZDogYmFzaCBlY2hvIHt7LlJ1bi5SZWdpc3RyeX19Cg=="),
 *                 Map.entry("platform", Map.ofEntries(
 *                     Map.entry("architecture", "amd64"),
 *                     Map.entry("os", "Linux")
 *                 )),
 *                 Map.entry("type", "EncodedTaskRunRequest"),
 *                 Map.entry("values", )
 *             ))
 *             .taskRunName("myRun")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:containerregistry:TaskRun myrun /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerRegistry/registries/{registryName}/taskRuns/{taskRunName}
 * ```
 */
public class TaskRun internal constructor(
    override val javaResource: com.pulumi.azurenative.containerregistry.TaskRun,
) : KotlinCustomResource(javaResource, TaskRunMapper) {
    /**
     * How the run should be forced to rerun even if the run request configuration has not changed
     */
    public val forceUpdateTag: Output<String>?
        get() = javaResource.forceUpdateTag().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Identity for the resource.
     */
    public val identity: Output<IdentityPropertiesResponse>?
        get() = javaResource.identity().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    identityPropertiesResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The location of the resource
     */
    public val location: Output<String>?
        get() = javaResource.location().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The name of the resource.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The provisioning state of this task run
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * The request (parameters) for the run
     */
    public val runRequest: Output<Any>?
        get() = javaResource.runRequest().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The result of this task run
     */
    public val runResult: Output<RunResponse>
        get() = javaResource.runResult().applyValue({ args0 ->
            args0.let({ args0 ->
                runResponseToKotlin(args0)
            })
        })

    /**
     * Metadata pertaining to creation and last modification of the resource.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * The type of the resource.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object TaskRunMapper : ResourceMapper<TaskRun> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.containerregistry.TaskRun::class == javaResource::class

    override fun map(javaResource: Resource): TaskRun = TaskRun(
        javaResource as
            com.pulumi.azurenative.containerregistry.TaskRun,
    )
}

/**
 * @see [TaskRun].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [TaskRun].
 */
public suspend fun taskRun(name: String, block: suspend TaskRunResourceBuilder.() -> Unit):
    TaskRun {
    val builder = TaskRunResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [TaskRun].
 * @param name The _unique_ name of the resulting resource.
 */
public fun taskRun(name: String): TaskRun {
    val builder = TaskRunResourceBuilder()
    builder.name(name)
    return builder.build()
}
