@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerregistry.kotlin

import com.pulumi.azurenative.containerregistry.WebhookArgs.builder
import com.pulumi.azurenative.containerregistry.kotlin.enums.WebhookAction
import com.pulumi.azurenative.containerregistry.kotlin.enums.WebhookStatus
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * An object that represents a webhook for a container registry.
 * Azure REST API version: 2022-12-01. Prior API version in Azure Native 1.x: 2019-05-01.
 * Other available API versions: 2023-01-01-preview, 2023-06-01-preview, 2023-07-01, 2023-08-01-preview, 2023-11-01-preview.
 * ## Example Usage
 * ### WebhookCreate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var webhook = new AzureNative.ContainerRegistry.Webhook("webhook", new()
 *     {
 *         Actions = new[]
 *         {
 *             "push",
 *         },
 *         CustomHeaders =
 *         {
 *             { "Authorization", "******" },
 *         },
 *         Location = "westus",
 *         RegistryName = "myRegistry",
 *         ResourceGroupName = "myResourceGroup",
 *         Scope = "myRepository",
 *         ServiceUri = "http://myservice.com",
 *         Status = "enabled",
 *         Tags =
 *         {
 *             { "key", "value" },
 *         },
 *         WebhookName = "myWebhook",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/containerregistry/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := containerregistry.NewWebhook(ctx, "webhook", &containerregistry.WebhookArgs{
 * 			Actions: pulumi.StringArray{
 * 				pulumi.String("push"),
 * 			},
 * 			CustomHeaders: pulumi.StringMap{
 * 				"Authorization": pulumi.String("******"),
 * 			},
 * 			Location:          pulumi.String("westus"),
 * 			RegistryName:      pulumi.String("myRegistry"),
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			Scope:             pulumi.String("myRepository"),
 * 			ServiceUri:        pulumi.String("http://myservice.com"),
 * 			Status:            pulumi.String("enabled"),
 * 			Tags: pulumi.StringMap{
 * 				"key": pulumi.String("value"),
 * 			},
 * 			WebhookName: pulumi.String("myWebhook"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.containerregistry.Webhook;
 * import com.pulumi.azurenative.containerregistry.WebhookArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var webhook = new Webhook("webhook", WebhookArgs.builder()
 *             .actions("push")
 *             .customHeaders(Map.of("Authorization", "******"))
 *             .location("westus")
 *             .registryName("myRegistry")
 *             .resourceGroupName("myResourceGroup")
 *             .scope("myRepository")
 *             .serviceUri("http://myservice.com")
 *             .status("enabled")
 *             .tags(Map.of("key", "value"))
 *             .webhookName("myWebhook")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:containerregistry:Webhook myWebhook /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerRegistry/registries/{registryName}/webhooks/{webhookName}
 * ```
 * @property actions The list of actions that trigger the webhook to post notifications.
 * @property customHeaders Custom headers that will be added to the webhook notifications.
 * @property location The location of the webhook. This cannot be changed after the resource is created.
 * @property registryName The name of the container registry.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property scope The scope of repositories where the event can be triggered. For example, 'foo:*' means events for all tags under repository 'foo'. 'foo:bar' means events for 'foo:bar' only. 'foo' is equivalent to 'foo:latest'. Empty means all events.
 * @property serviceUri The service URI for the webhook to post notifications.
 * @property status The status of the webhook at the time the operation was called.
 * @property tags The tags for the webhook.
 * @property webhookName The name of the webhook.
 */
public data class WebhookArgs(
    public val actions: Output<List<Either<String, WebhookAction>>>? = null,
    public val customHeaders: Output<Map<String, String>>? = null,
    public val location: Output<String>? = null,
    public val registryName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val scope: Output<String>? = null,
    public val serviceUri: Output<String>? = null,
    public val status: Output<Either<String, WebhookStatus>>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val webhookName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.containerregistry.WebhookArgs> {
    override fun toJava(): com.pulumi.azurenative.containerregistry.WebhookArgs =
        com.pulumi.azurenative.containerregistry.WebhookArgs.builder()
            .actions(
                actions?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.transform(
                            { args0 -> args0 },
                            { args0 -> args0.let({ args0 -> args0.toJava() }) },
                        )
                    })
                }),
            )
            .customHeaders(
                customHeaders?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .location(location?.applyValue({ args0 -> args0 }))
            .registryName(registryName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .scope(scope?.applyValue({ args0 -> args0 }))
            .serviceUri(serviceUri?.applyValue({ args0 -> args0 }))
            .status(
                status?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .webhookName(webhookName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [WebhookArgs].
 */
@PulumiTagMarker
public class WebhookArgsBuilder internal constructor() {
    private var actions: Output<List<Either<String, WebhookAction>>>? = null

    private var customHeaders: Output<Map<String, String>>? = null

    private var location: Output<String>? = null

    private var registryName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var scope: Output<String>? = null

    private var serviceUri: Output<String>? = null

    private var status: Output<Either<String, WebhookStatus>>? = null

    private var tags: Output<Map<String, String>>? = null

    private var webhookName: Output<String>? = null

    /**
     * @param value The list of actions that trigger the webhook to post notifications.
     */
    @JvmName("dhcewembxuxoonfq")
    public suspend fun actions(`value`: Output<List<Either<String, WebhookAction>>>) {
        this.actions = value
    }

    @JvmName("frrklkkytlimtenn")
    public suspend fun actions(vararg values: Output<Either<String, WebhookAction>>) {
        this.actions = Output.all(values.asList())
    }

    /**
     * @param values The list of actions that trigger the webhook to post notifications.
     */
    @JvmName("udfananijwjyldnp")
    public suspend fun actions(values: List<Output<Either<String, WebhookAction>>>) {
        this.actions = Output.all(values)
    }

    /**
     * @param value Custom headers that will be added to the webhook notifications.
     */
    @JvmName("mpnjpiqcavmvegkv")
    public suspend fun customHeaders(`value`: Output<Map<String, String>>) {
        this.customHeaders = value
    }

    /**
     * @param value The location of the webhook. This cannot be changed after the resource is created.
     */
    @JvmName("eesvcoiygjqlhmak")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The name of the container registry.
     */
    @JvmName("nckpvgybkojjdsbm")
    public suspend fun registryName(`value`: Output<String>) {
        this.registryName = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("kixeqxiertaegxtn")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The scope of repositories where the event can be triggered. For example, 'foo:*' means events for all tags under repository 'foo'. 'foo:bar' means events for 'foo:bar' only. 'foo' is equivalent to 'foo:latest'. Empty means all events.
     */
    @JvmName("yboxiivksxbeketw")
    public suspend fun scope(`value`: Output<String>) {
        this.scope = value
    }

    /**
     * @param value The service URI for the webhook to post notifications.
     */
    @JvmName("ujmeaengyqkhtwuh")
    public suspend fun serviceUri(`value`: Output<String>) {
        this.serviceUri = value
    }

    /**
     * @param value The status of the webhook at the time the operation was called.
     */
    @JvmName("rcarhdbptdyklkoi")
    public suspend fun status(`value`: Output<Either<String, WebhookStatus>>) {
        this.status = value
    }

    /**
     * @param value The tags for the webhook.
     */
    @JvmName("ksqjsuhoknuojvdb")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The name of the webhook.
     */
    @JvmName("nfvgdwroilaqhjvk")
    public suspend fun webhookName(`value`: Output<String>) {
        this.webhookName = value
    }

    /**
     * @param value The list of actions that trigger the webhook to post notifications.
     */
    @JvmName("lobaafunwvjvmchc")
    public suspend fun actions(`value`: List<Either<String, WebhookAction>>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.actions = mapped
    }

    /**
     * @param values The list of actions that trigger the webhook to post notifications.
     */
    @JvmName("vwwpkjkbkybgyeqa")
    public suspend fun actions(vararg values: Either<String, WebhookAction>) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.actions = mapped
    }

    /**
     * @param value Custom headers that will be added to the webhook notifications.
     */
    @JvmName("vpyhugotrbtmquva")
    public suspend fun customHeaders(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customHeaders = mapped
    }

    /**
     * @param values Custom headers that will be added to the webhook notifications.
     */
    @JvmName("phhlniaktjkmxytn")
    public fun customHeaders(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.customHeaders = mapped
    }

    /**
     * @param value The location of the webhook. This cannot be changed after the resource is created.
     */
    @JvmName("tbyhddpdcnoabdfe")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The name of the container registry.
     */
    @JvmName("hhgltiguihivkhdx")
    public suspend fun registryName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.registryName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("mtksvuloivpfypva")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The scope of repositories where the event can be triggered. For example, 'foo:*' means events for all tags under repository 'foo'. 'foo:bar' means events for 'foo:bar' only. 'foo' is equivalent to 'foo:latest'. Empty means all events.
     */
    @JvmName("wpvdwkfuochobhuc")
    public suspend fun scope(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scope = mapped
    }

    /**
     * @param value The service URI for the webhook to post notifications.
     */
    @JvmName("yhodejqaqsukkjff")
    public suspend fun serviceUri(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceUri = mapped
    }

    /**
     * @param value The status of the webhook at the time the operation was called.
     */
    @JvmName("nmojtlsqftjcavtd")
    public suspend fun status(`value`: Either<String, WebhookStatus>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.status = mapped
    }

    /**
     * @param value The status of the webhook at the time the operation was called.
     */
    @JvmName("tkgaiilcunjvubbq")
    public fun status(`value`: String) {
        val toBeMapped = Either.ofLeft<String, WebhookStatus>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.status = mapped
    }

    /**
     * @param value The status of the webhook at the time the operation was called.
     */
    @JvmName("yernknmiomrhslff")
    public fun status(`value`: WebhookStatus) {
        val toBeMapped = Either.ofRight<String, WebhookStatus>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.status = mapped
    }

    /**
     * @param value The tags for the webhook.
     */
    @JvmName("spmpqjwutcqqswrp")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values The tags for the webhook.
     */
    @JvmName("mhvtvtolhvuwfcco")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The name of the webhook.
     */
    @JvmName("ephllsmsycnasdbl")
    public suspend fun webhookName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.webhookName = mapped
    }

    internal fun build(): WebhookArgs = WebhookArgs(
        actions = actions,
        customHeaders = customHeaders,
        location = location,
        registryName = registryName,
        resourceGroupName = resourceGroupName,
        scope = scope,
        serviceUri = serviceUri,
        status = status,
        tags = tags,
        webhookName = webhookName,
    )
}
