@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerregistry.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The SKU name of the container registry. Required for registry creation.
 */
public enum class SkuName(
    public val javaValue: com.pulumi.azurenative.containerregistry.enums.SkuName,
) : ConvertibleToJava<com.pulumi.azurenative.containerregistry.enums.SkuName> {
    Classic(com.pulumi.azurenative.containerregistry.enums.SkuName.Classic),
    Basic(com.pulumi.azurenative.containerregistry.enums.SkuName.Basic),
    Standard(com.pulumi.azurenative.containerregistry.enums.SkuName.Standard),
    Premium(com.pulumi.azurenative.containerregistry.enums.SkuName.Premium),
    ;

    override fun toJava(): com.pulumi.azurenative.containerregistry.enums.SkuName = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.containerregistry.enums.SkuName): SkuName =
            SkuName.values().first { it.javaValue == javaType }
    }
}
