@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerregistry.kotlin.inputs

import com.pulumi.azurenative.containerregistry.inputs.ArchivePackageSourcePropertiesArgs.builder
import com.pulumi.azurenative.containerregistry.kotlin.enums.PackageSourceType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The properties of the archive package source.
 * @property type The type of package source for a archive.
 * @property url The external repository url.
 */
public data class ArchivePackageSourcePropertiesArgs(
    public val type: Output<Either<String, PackageSourceType>>? = null,
    public val url: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.containerregistry.inputs.ArchivePackageSourcePropertiesArgs> {
    override fun toJava():
        com.pulumi.azurenative.containerregistry.inputs.ArchivePackageSourcePropertiesArgs =
        com.pulumi.azurenative.containerregistry.inputs.ArchivePackageSourcePropertiesArgs.builder()
            .type(
                type?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .url(url?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ArchivePackageSourcePropertiesArgs].
 */
@PulumiTagMarker
public class ArchivePackageSourcePropertiesArgsBuilder internal constructor() {
    private var type: Output<Either<String, PackageSourceType>>? = null

    private var url: Output<String>? = null

    /**
     * @param value The type of package source for a archive.
     */
    @JvmName("fdqfmivmnawwrrkm")
    public suspend fun type(`value`: Output<Either<String, PackageSourceType>>) {
        this.type = value
    }

    /**
     * @param value The external repository url.
     */
    @JvmName("hejoxreckjdemtdf")
    public suspend fun url(`value`: Output<String>) {
        this.url = value
    }

    /**
     * @param value The type of package source for a archive.
     */
    @JvmName("jkcmxidsvrmjupuq")
    public suspend fun type(`value`: Either<String, PackageSourceType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value The type of package source for a archive.
     */
    @JvmName("yainxcnmprosexvg")
    public fun type(`value`: String) {
        val toBeMapped = Either.ofLeft<String, PackageSourceType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value The type of package source for a archive.
     */
    @JvmName("dwbdocrmbnrkmsif")
    public fun type(`value`: PackageSourceType) {
        val toBeMapped = Either.ofRight<String, PackageSourceType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value The external repository url.
     */
    @JvmName("dkiudcfecqmyvmqg")
    public suspend fun url(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.url = mapped
    }

    internal fun build(): ArchivePackageSourcePropertiesArgs = ArchivePackageSourcePropertiesArgs(
        type = type,
        url = url,
    )
}
