@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerregistry.kotlin.inputs

import com.pulumi.azurenative.containerregistry.inputs.DockerBuildStepArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * The Docker build step.
 * @property arguments The collection of override arguments to be used when executing this build step.
 * @property contextAccessToken The token (git PAT or SAS token of storage account blob) associated with the context for a step.
 * @property contextPath The URL(absolute or relative) of the source context for the task step.
 * @property dockerFilePath The Docker file path relative to the source context.
 * @property imageNames The fully qualified image names including the repository and tag.
 * @property isPushEnabled The value of this property indicates whether the image built should be pushed to the registry or not.
 * @property noCache The value of this property indicates whether the image cache is enabled or not.
 * @property target The name of the target build stage for the docker build.
 * @property type The type of the step.
 * Expected value is 'Docker'.
 */
public data class DockerBuildStepArgs(
    public val arguments: Output<List<ArgumentArgs>>? = null,
    public val contextAccessToken: Output<String>? = null,
    public val contextPath: Output<String>? = null,
    public val dockerFilePath: Output<String>,
    public val imageNames: Output<List<String>>? = null,
    public val isPushEnabled: Output<Boolean>? = null,
    public val noCache: Output<Boolean>? = null,
    public val target: Output<String>? = null,
    public val type: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.containerregistry.inputs.DockerBuildStepArgs> {
    override fun toJava(): com.pulumi.azurenative.containerregistry.inputs.DockerBuildStepArgs =
        com.pulumi.azurenative.containerregistry.inputs.DockerBuildStepArgs.builder()
            .arguments(
                arguments?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .contextAccessToken(contextAccessToken?.applyValue({ args0 -> args0 }))
            .contextPath(contextPath?.applyValue({ args0 -> args0 }))
            .dockerFilePath(dockerFilePath.applyValue({ args0 -> args0 }))
            .imageNames(imageNames?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .isPushEnabled(isPushEnabled?.applyValue({ args0 -> args0 }))
            .noCache(noCache?.applyValue({ args0 -> args0 }))
            .target(target?.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DockerBuildStepArgs].
 */
@PulumiTagMarker
public class DockerBuildStepArgsBuilder internal constructor() {
    private var arguments: Output<List<ArgumentArgs>>? = null

    private var contextAccessToken: Output<String>? = null

    private var contextPath: Output<String>? = null

    private var dockerFilePath: Output<String>? = null

    private var imageNames: Output<List<String>>? = null

    private var isPushEnabled: Output<Boolean>? = null

    private var noCache: Output<Boolean>? = null

    private var target: Output<String>? = null

    private var type: Output<String>? = null

    /**
     * @param value The collection of override arguments to be used when executing this build step.
     */
    @JvmName("srvsvwmhikfvaflx")
    public suspend fun arguments(`value`: Output<List<ArgumentArgs>>) {
        this.arguments = value
    }

    @JvmName("tvolgnlbgbowsooq")
    public suspend fun arguments(vararg values: Output<ArgumentArgs>) {
        this.arguments = Output.all(values.asList())
    }

    /**
     * @param values The collection of override arguments to be used when executing this build step.
     */
    @JvmName("fakidsorwkuxypnl")
    public suspend fun arguments(values: List<Output<ArgumentArgs>>) {
        this.arguments = Output.all(values)
    }

    /**
     * @param value The token (git PAT or SAS token of storage account blob) associated with the context for a step.
     */
    @JvmName("qjwvvdbwgimykwkt")
    public suspend fun contextAccessToken(`value`: Output<String>) {
        this.contextAccessToken = value
    }

    /**
     * @param value The URL(absolute or relative) of the source context for the task step.
     */
    @JvmName("esnixsuuibodgroc")
    public suspend fun contextPath(`value`: Output<String>) {
        this.contextPath = value
    }

    /**
     * @param value The Docker file path relative to the source context.
     */
    @JvmName("uvticdlgnwmrifuq")
    public suspend fun dockerFilePath(`value`: Output<String>) {
        this.dockerFilePath = value
    }

    /**
     * @param value The fully qualified image names including the repository and tag.
     */
    @JvmName("vdhepspawkkhtdyn")
    public suspend fun imageNames(`value`: Output<List<String>>) {
        this.imageNames = value
    }

    @JvmName("txgdqxeenwguxmqo")
    public suspend fun imageNames(vararg values: Output<String>) {
        this.imageNames = Output.all(values.asList())
    }

    /**
     * @param values The fully qualified image names including the repository and tag.
     */
    @JvmName("orpohffstdlqayhy")
    public suspend fun imageNames(values: List<Output<String>>) {
        this.imageNames = Output.all(values)
    }

    /**
     * @param value The value of this property indicates whether the image built should be pushed to the registry or not.
     */
    @JvmName("utwgamvkmrqfidjg")
    public suspend fun isPushEnabled(`value`: Output<Boolean>) {
        this.isPushEnabled = value
    }

    /**
     * @param value The value of this property indicates whether the image cache is enabled or not.
     */
    @JvmName("glowfniusicuaadj")
    public suspend fun noCache(`value`: Output<Boolean>) {
        this.noCache = value
    }

    /**
     * @param value The name of the target build stage for the docker build.
     */
    @JvmName("vslkxjqwfkjsyovv")
    public suspend fun target(`value`: Output<String>) {
        this.target = value
    }

    /**
     * @param value The type of the step.
     * Expected value is 'Docker'.
     */
    @JvmName("ciwdyijbqttaegxs")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value The collection of override arguments to be used when executing this build step.
     */
    @JvmName("skbakxubkwmpteni")
    public suspend fun arguments(`value`: List<ArgumentArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.arguments = mapped
    }

    /**
     * @param argument The collection of override arguments to be used when executing this build step.
     */
    @JvmName("qsgvubkadsbendiq")
    public suspend fun arguments(argument: List<suspend ArgumentArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { ArgumentArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.arguments = mapped
    }

    /**
     * @param argument The collection of override arguments to be used when executing this build step.
     */
    @JvmName("awwmsnnbbqillmck")
    public suspend fun arguments(vararg argument: suspend ArgumentArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { ArgumentArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.arguments = mapped
    }

    /**
     * @param argument The collection of override arguments to be used when executing this build step.
     */
    @JvmName("mebakapetjoafwnx")
    public suspend fun arguments(argument: suspend ArgumentArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(ArgumentArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.arguments = mapped
    }

    /**
     * @param values The collection of override arguments to be used when executing this build step.
     */
    @JvmName("chffkrnmmhwfyxli")
    public suspend fun arguments(vararg values: ArgumentArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.arguments = mapped
    }

    /**
     * @param value The token (git PAT or SAS token of storage account blob) associated with the context for a step.
     */
    @JvmName("kopyfroorrgqnwgq")
    public suspend fun contextAccessToken(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.contextAccessToken = mapped
    }

    /**
     * @param value The URL(absolute or relative) of the source context for the task step.
     */
    @JvmName("alujsstyujtpqdbm")
    public suspend fun contextPath(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.contextPath = mapped
    }

    /**
     * @param value The Docker file path relative to the source context.
     */
    @JvmName("okkouevwniawdugf")
    public suspend fun dockerFilePath(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dockerFilePath = mapped
    }

    /**
     * @param value The fully qualified image names including the repository and tag.
     */
    @JvmName("snpganldpmuynygm")
    public suspend fun imageNames(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.imageNames = mapped
    }

    /**
     * @param values The fully qualified image names including the repository and tag.
     */
    @JvmName("svpxercwthjnsdek")
    public suspend fun imageNames(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.imageNames = mapped
    }

    /**
     * @param value The value of this property indicates whether the image built should be pushed to the registry or not.
     */
    @JvmName("onltgasmjvjalivk")
    public suspend fun isPushEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isPushEnabled = mapped
    }

    /**
     * @param value The value of this property indicates whether the image cache is enabled or not.
     */
    @JvmName("gosjopdfjbbbwxmn")
    public suspend fun noCache(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.noCache = mapped
    }

    /**
     * @param value The name of the target build stage for the docker build.
     */
    @JvmName("hnhsaetnkcnuahuv")
    public suspend fun target(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.target = mapped
    }

    /**
     * @param value The type of the step.
     * Expected value is 'Docker'.
     */
    @JvmName("atmtejullklrtuqn")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): DockerBuildStepArgs = DockerBuildStepArgs(
        arguments = arguments,
        contextAccessToken = contextAccessToken,
        contextPath = contextPath,
        dockerFilePath = dockerFilePath ?: throw PulumiNullFieldException("dockerFilePath"),
        imageNames = imageNames,
        isPushEnabled = isPushEnabled,
        noCache = noCache,
        target = target,
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
