@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerregistry.kotlin.inputs

import com.pulumi.azurenative.containerregistry.inputs.ExportPipelineTargetPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The properties of the export pipeline target.
 * @property keyVaultUri They key vault secret uri to obtain the target storage SAS token.
 * @property type The type of target for the export pipeline.
 * @property uri The target uri of the export pipeline.
 * When 'AzureStorageBlob': "https://accountName.blob.core.windows.net/containerName/blobName"
 * When 'AzureStorageBlobContainer':  "https://accountName.blob.core.windows.net/containerName"
 */
public data class ExportPipelineTargetPropertiesArgs(
    public val keyVaultUri: Output<String>,
    public val type: Output<String>? = null,
    public val uri: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.containerregistry.inputs.ExportPipelineTargetPropertiesArgs> {
    override fun toJava():
        com.pulumi.azurenative.containerregistry.inputs.ExportPipelineTargetPropertiesArgs =
        com.pulumi.azurenative.containerregistry.inputs.ExportPipelineTargetPropertiesArgs.builder()
            .keyVaultUri(keyVaultUri.applyValue({ args0 -> args0 }))
            .type(type?.applyValue({ args0 -> args0 }))
            .uri(uri?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ExportPipelineTargetPropertiesArgs].
 */
@PulumiTagMarker
public class ExportPipelineTargetPropertiesArgsBuilder internal constructor() {
    private var keyVaultUri: Output<String>? = null

    private var type: Output<String>? = null

    private var uri: Output<String>? = null

    /**
     * @param value They key vault secret uri to obtain the target storage SAS token.
     */
    @JvmName("fuhyidtdkcmiuejo")
    public suspend fun keyVaultUri(`value`: Output<String>) {
        this.keyVaultUri = value
    }

    /**
     * @param value The type of target for the export pipeline.
     */
    @JvmName("iccxpnojaebtuall")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value The target uri of the export pipeline.
     * When 'AzureStorageBlob': "https://accountName.blob.core.windows.net/containerName/blobName"
     * When 'AzureStorageBlobContainer':  "https://accountName.blob.core.windows.net/containerName"
     */
    @JvmName("yejnpowspfdwbctt")
    public suspend fun uri(`value`: Output<String>) {
        this.uri = value
    }

    /**
     * @param value They key vault secret uri to obtain the target storage SAS token.
     */
    @JvmName("puvvuvhtgmncpfsm")
    public suspend fun keyVaultUri(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.keyVaultUri = mapped
    }

    /**
     * @param value The type of target for the export pipeline.
     */
    @JvmName("ovyixtkbsnajibrp")
    public suspend fun type(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value The target uri of the export pipeline.
     * When 'AzureStorageBlob': "https://accountName.blob.core.windows.net/containerName/blobName"
     * When 'AzureStorageBlobContainer':  "https://accountName.blob.core.windows.net/containerName"
     */
    @JvmName("rvfowruwfmyhdkfc")
    public suspend fun uri(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.uri = mapped
    }

    internal fun build(): ExportPipelineTargetPropertiesArgs = ExportPipelineTargetPropertiesArgs(
        keyVaultUri = keyVaultUri ?: throw PulumiNullFieldException("keyVaultUri"),
        type = type,
        uri = uri,
    )
}
