@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerregistry.kotlin.inputs

import com.pulumi.azurenative.containerregistry.inputs.GetArchifePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property archiveName The name of the archive resource.
 * @property packageType The type of the package resource.
 * @property registryName The name of the container registry.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetArchifePlainArgs(
    public val archiveName: String,
    public val packageType: String,
    public val registryName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.containerregistry.inputs.GetArchifePlainArgs> {
    override fun toJava(): com.pulumi.azurenative.containerregistry.inputs.GetArchifePlainArgs =
        com.pulumi.azurenative.containerregistry.inputs.GetArchifePlainArgs.builder()
            .archiveName(archiveName.let({ args0 -> args0 }))
            .packageType(packageType.let({ args0 -> args0 }))
            .registryName(registryName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetArchifePlainArgs].
 */
@PulumiTagMarker
public class GetArchifePlainArgsBuilder internal constructor() {
    private var archiveName: String? = null

    private var packageType: String? = null

    private var registryName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the archive resource.
     */
    @JvmName("ucxfuxdxddorodnu")
    public suspend fun archiveName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.archiveName = mapped
    }

    /**
     * @param value The type of the package resource.
     */
    @JvmName("whocfiqewvfcrecd")
    public suspend fun packageType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.packageType = mapped
    }

    /**
     * @param value The name of the container registry.
     */
    @JvmName("yicggsidldkrisbl")
    public suspend fun registryName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.registryName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("kspcbtmbuorwlbnf")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetArchifePlainArgs = GetArchifePlainArgs(
        archiveName = archiveName ?: throw PulumiNullFieldException("archiveName"),
        packageType = packageType ?: throw PulumiNullFieldException("packageType"),
        registryName = registryName ?: throw PulumiNullFieldException("registryName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
