@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerregistry.kotlin.inputs

import com.pulumi.azurenative.containerregistry.inputs.GetArchiveVersionPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property archiveName The name of the archive resource.
 * @property archiveVersionName The name of the archive version resource.
 * @property packageType The type of the package resource.
 * @property registryName The name of the container registry.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetArchiveVersionPlainArgs(
    public val archiveName: String,
    public val archiveVersionName: String,
    public val packageType: String,
    public val registryName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.containerregistry.inputs.GetArchiveVersionPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.containerregistry.inputs.GetArchiveVersionPlainArgs =
        com.pulumi.azurenative.containerregistry.inputs.GetArchiveVersionPlainArgs.builder()
            .archiveName(archiveName.let({ args0 -> args0 }))
            .archiveVersionName(archiveVersionName.let({ args0 -> args0 }))
            .packageType(packageType.let({ args0 -> args0 }))
            .registryName(registryName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetArchiveVersionPlainArgs].
 */
@PulumiTagMarker
public class GetArchiveVersionPlainArgsBuilder internal constructor() {
    private var archiveName: String? = null

    private var archiveVersionName: String? = null

    private var packageType: String? = null

    private var registryName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the archive resource.
     */
    @JvmName("rceylhhiyhbrhjhe")
    public suspend fun archiveName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.archiveName = mapped
    }

    /**
     * @param value The name of the archive version resource.
     */
    @JvmName("wmcdbcuvamiksjkf")
    public suspend fun archiveVersionName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.archiveVersionName = mapped
    }

    /**
     * @param value The type of the package resource.
     */
    @JvmName("aqjtkhyivknupvoj")
    public suspend fun packageType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.packageType = mapped
    }

    /**
     * @param value The name of the container registry.
     */
    @JvmName("hrwruxgesyqjpaww")
    public suspend fun registryName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.registryName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("yddbcxfemdqaaxbb")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetArchiveVersionPlainArgs = GetArchiveVersionPlainArgs(
        archiveName = archiveName ?: throw PulumiNullFieldException("archiveName"),
        archiveVersionName = archiveVersionName ?: throw PulumiNullFieldException("archiveVersionName"),
        packageType = packageType ?: throw PulumiNullFieldException("packageType"),
        registryName = registryName ?: throw PulumiNullFieldException("registryName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
