@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerregistry.kotlin.inputs

import com.pulumi.azurenative.containerregistry.inputs.GetCacheRulePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property cacheRuleName The name of the cache rule.
 * @property registryName The name of the container registry.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetCacheRulePlainArgs(
    public val cacheRuleName: String,
    public val registryName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.containerregistry.inputs.GetCacheRulePlainArgs> {
    override fun toJava(): com.pulumi.azurenative.containerregistry.inputs.GetCacheRulePlainArgs =
        com.pulumi.azurenative.containerregistry.inputs.GetCacheRulePlainArgs.builder()
            .cacheRuleName(cacheRuleName.let({ args0 -> args0 }))
            .registryName(registryName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetCacheRulePlainArgs].
 */
@PulumiTagMarker
public class GetCacheRulePlainArgsBuilder internal constructor() {
    private var cacheRuleName: String? = null

    private var registryName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the cache rule.
     */
    @JvmName("hqoumhcysekkpnnf")
    public suspend fun cacheRuleName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.cacheRuleName = mapped
    }

    /**
     * @param value The name of the container registry.
     */
    @JvmName("tcdqqsgrcyxtxntq")
    public suspend fun registryName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.registryName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("xxdpdyddnewnyylq")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetCacheRulePlainArgs = GetCacheRulePlainArgs(
        cacheRuleName = cacheRuleName ?: throw PulumiNullFieldException("cacheRuleName"),
        registryName = registryName ?: throw PulumiNullFieldException("registryName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
