@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerregistry.kotlin.inputs

import com.pulumi.azurenative.containerregistry.inputs.GetConnectedRegistryPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property connectedRegistryName The name of the connected registry.
 * @property registryName The name of the container registry.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetConnectedRegistryPlainArgs(
    public val connectedRegistryName: String,
    public val registryName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.containerregistry.inputs.GetConnectedRegistryPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.containerregistry.inputs.GetConnectedRegistryPlainArgs =
        com.pulumi.azurenative.containerregistry.inputs.GetConnectedRegistryPlainArgs.builder()
            .connectedRegistryName(connectedRegistryName.let({ args0 -> args0 }))
            .registryName(registryName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetConnectedRegistryPlainArgs].
 */
@PulumiTagMarker
public class GetConnectedRegistryPlainArgsBuilder internal constructor() {
    private var connectedRegistryName: String? = null

    private var registryName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the connected registry.
     */
    @JvmName("xtbgnjpcrdnbkici")
    public suspend fun connectedRegistryName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.connectedRegistryName = mapped
    }

    /**
     * @param value The name of the container registry.
     */
    @JvmName("bnqbbhxoyhrgsgua")
    public suspend fun registryName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.registryName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("gmquoanjcfpkqahe")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetConnectedRegistryPlainArgs = GetConnectedRegistryPlainArgs(
        connectedRegistryName = connectedRegistryName ?: throw
            PulumiNullFieldException("connectedRegistryName"),
        registryName = registryName ?: throw PulumiNullFieldException("registryName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
