@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerregistry.kotlin.inputs

import com.pulumi.azurenative.containerregistry.inputs.GetRegistryPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property registryName The name of the container registry.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetRegistryPlainArgs(
    public val registryName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.containerregistry.inputs.GetRegistryPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.containerregistry.inputs.GetRegistryPlainArgs =
        com.pulumi.azurenative.containerregistry.inputs.GetRegistryPlainArgs.builder()
            .registryName(registryName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetRegistryPlainArgs].
 */
@PulumiTagMarker
public class GetRegistryPlainArgsBuilder internal constructor() {
    private var registryName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the container registry.
     */
    @JvmName("emrkpavqsrnvmwoa")
    public suspend fun registryName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.registryName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("vejedkvlwoslmwfk")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetRegistryPlainArgs = GetRegistryPlainArgs(
        registryName = registryName ?: throw PulumiNullFieldException("registryName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
