@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerregistry.kotlin.inputs

import com.pulumi.azurenative.containerregistry.inputs.GetScopeMapPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property registryName The name of the container registry.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property scopeMapName The name of the scope map.
 */
public data class GetScopeMapPlainArgs(
    public val registryName: String,
    public val resourceGroupName: String,
    public val scopeMapName: String,
) : ConvertibleToJava<com.pulumi.azurenative.containerregistry.inputs.GetScopeMapPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.containerregistry.inputs.GetScopeMapPlainArgs =
        com.pulumi.azurenative.containerregistry.inputs.GetScopeMapPlainArgs.builder()
            .registryName(registryName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .scopeMapName(scopeMapName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetScopeMapPlainArgs].
 */
@PulumiTagMarker
public class GetScopeMapPlainArgsBuilder internal constructor() {
    private var registryName: String? = null

    private var resourceGroupName: String? = null

    private var scopeMapName: String? = null

    /**
     * @param value The name of the container registry.
     */
    @JvmName("tpfkqcadhsxtlmny")
    public suspend fun registryName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.registryName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("bexbqtafncefooks")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the scope map.
     */
    @JvmName("bqswjqkjnyvbobnt")
    public suspend fun scopeMapName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.scopeMapName = mapped
    }

    internal fun build(): GetScopeMapPlainArgs = GetScopeMapPlainArgs(
        registryName = registryName ?: throw PulumiNullFieldException("registryName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        scopeMapName = scopeMapName ?: throw PulumiNullFieldException("scopeMapName"),
    )
}
