@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerregistry.kotlin.inputs

import com.pulumi.azurenative.containerregistry.inputs.GetTokenPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property registryName The name of the container registry.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property tokenName The name of the token.
 */
public data class GetTokenPlainArgs(
    public val registryName: String,
    public val resourceGroupName: String,
    public val tokenName: String,
) : ConvertibleToJava<com.pulumi.azurenative.containerregistry.inputs.GetTokenPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.containerregistry.inputs.GetTokenPlainArgs =
        com.pulumi.azurenative.containerregistry.inputs.GetTokenPlainArgs.builder()
            .registryName(registryName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .tokenName(tokenName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetTokenPlainArgs].
 */
@PulumiTagMarker
public class GetTokenPlainArgsBuilder internal constructor() {
    private var registryName: String? = null

    private var resourceGroupName: String? = null

    private var tokenName: String? = null

    /**
     * @param value The name of the container registry.
     */
    @JvmName("hutdbiglmbndppdy")
    public suspend fun registryName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.registryName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("oiierjdxxvvnuloc")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the token.
     */
    @JvmName("wpgsxurcuuvsdsoh")
    public suspend fun tokenName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.tokenName = mapped
    }

    internal fun build(): GetTokenPlainArgs = GetTokenPlainArgs(
        registryName = registryName ?: throw PulumiNullFieldException("registryName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        tokenName = tokenName ?: throw PulumiNullFieldException("tokenName"),
    )
}
