@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerregistry.kotlin.inputs

import com.pulumi.azurenative.containerregistry.inputs.ListTaskDetailsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property registryName The name of the container registry.
 * @property resourceGroupName The name of the resource group to which the container registry belongs.
 * @property taskName The name of the container registry task.
 */
public data class ListTaskDetailsPlainArgs(
    public val registryName: String,
    public val resourceGroupName: String,
    public val taskName: String,
) : ConvertibleToJava<com.pulumi.azurenative.containerregistry.inputs.ListTaskDetailsPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.containerregistry.inputs.ListTaskDetailsPlainArgs =
        com.pulumi.azurenative.containerregistry.inputs.ListTaskDetailsPlainArgs.builder()
            .registryName(registryName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .taskName(taskName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [ListTaskDetailsPlainArgs].
 */
@PulumiTagMarker
public class ListTaskDetailsPlainArgsBuilder internal constructor() {
    private var registryName: String? = null

    private var resourceGroupName: String? = null

    private var taskName: String? = null

    /**
     * @param value The name of the container registry.
     */
    @JvmName("rdruhcdevoqsknuk")
    public suspend fun registryName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.registryName = mapped
    }

    /**
     * @param value The name of the resource group to which the container registry belongs.
     */
    @JvmName("ttwhhjhqhrfcudti")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the container registry task.
     */
    @JvmName("uiqwefpsbgwtmblk")
    public suspend fun taskName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.taskName = mapped
    }

    internal fun build(): ListTaskDetailsPlainArgs = ListTaskDetailsPlainArgs(
        registryName = registryName ?: throw PulumiNullFieldException("registryName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        taskName = taskName ?: throw PulumiNullFieldException("taskName"),
    )
}
