@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerregistry.kotlin.inputs

import com.pulumi.azurenative.containerregistry.inputs.PrivateEndpointArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The Private Endpoint resource.
 * @property id This is private endpoint resource created with Microsoft.Network resource provider.
 */
public data class PrivateEndpointArgs(
    public val id: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.containerregistry.inputs.PrivateEndpointArgs> {
    override fun toJava(): com.pulumi.azurenative.containerregistry.inputs.PrivateEndpointArgs =
        com.pulumi.azurenative.containerregistry.inputs.PrivateEndpointArgs.builder()
            .id(id?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PrivateEndpointArgs].
 */
@PulumiTagMarker
public class PrivateEndpointArgsBuilder internal constructor() {
    private var id: Output<String>? = null

    /**
     * @param value This is private endpoint resource created with Microsoft.Network resource provider.
     */
    @JvmName("wqiwmeppnhvfjmrw")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value This is private endpoint resource created with Microsoft.Network resource provider.
     */
    @JvmName("cxgxqfcwudyibuiu")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    internal fun build(): PrivateEndpointArgs = PrivateEndpointArgs(
        id = id,
    )
}
