@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerregistry.kotlin.inputs

import com.pulumi.azurenative.containerregistry.inputs.PrivateLinkServiceConnectionStateArgs.builder
import com.pulumi.azurenative.containerregistry.kotlin.enums.ActionsRequired
import com.pulumi.azurenative.containerregistry.kotlin.enums.ConnectionStatus
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The state of a private link service connection.
 * @property actionsRequired A message indicating if changes on the service provider require any updates on the consumer.
 * @property description The description for connection status. For example if connection is rejected it can indicate reason for rejection.
 * @property status The private link service connection status.
 */
public data class PrivateLinkServiceConnectionStateArgs(
    public val actionsRequired: Output<Either<String, ActionsRequired>>? = null,
    public val description: Output<String>? = null,
    public val status: Output<Either<String, ConnectionStatus>>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.containerregistry.inputs.PrivateLinkServiceConnectionStateArgs> {
    override fun toJava():
        com.pulumi.azurenative.containerregistry.inputs.PrivateLinkServiceConnectionStateArgs =
        com.pulumi.azurenative.containerregistry.inputs.PrivateLinkServiceConnectionStateArgs.builder()
            .actionsRequired(
                actionsRequired?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .description(description?.applyValue({ args0 -> args0 }))
            .status(
                status?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [PrivateLinkServiceConnectionStateArgs].
 */
@PulumiTagMarker
public class PrivateLinkServiceConnectionStateArgsBuilder internal constructor() {
    private var actionsRequired: Output<Either<String, ActionsRequired>>? = null

    private var description: Output<String>? = null

    private var status: Output<Either<String, ConnectionStatus>>? = null

    /**
     * @param value A message indicating if changes on the service provider require any updates on the consumer.
     */
    @JvmName("vpuymbdhquhygmaj")
    public suspend fun actionsRequired(`value`: Output<Either<String, ActionsRequired>>) {
        this.actionsRequired = value
    }

    /**
     * @param value The description for connection status. For example if connection is rejected it can indicate reason for rejection.
     */
    @JvmName("kowhfoljvekkivie")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The private link service connection status.
     */
    @JvmName("bcnbicrlgofwllgi")
    public suspend fun status(`value`: Output<Either<String, ConnectionStatus>>) {
        this.status = value
    }

    /**
     * @param value A message indicating if changes on the service provider require any updates on the consumer.
     */
    @JvmName("oqwmhuvodbfkimlv")
    public suspend fun actionsRequired(`value`: Either<String, ActionsRequired>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.actionsRequired = mapped
    }

    /**
     * @param value A message indicating if changes on the service provider require any updates on the consumer.
     */
    @JvmName("efxraulivxkuxxmd")
    public fun actionsRequired(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ActionsRequired>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.actionsRequired = mapped
    }

    /**
     * @param value A message indicating if changes on the service provider require any updates on the consumer.
     */
    @JvmName("okvxyxefvqubrlfd")
    public fun actionsRequired(`value`: ActionsRequired) {
        val toBeMapped = Either.ofRight<String, ActionsRequired>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.actionsRequired = mapped
    }

    /**
     * @param value The description for connection status. For example if connection is rejected it can indicate reason for rejection.
     */
    @JvmName("bnyngyyxdwsehcvy")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The private link service connection status.
     */
    @JvmName("qdancooosnnvtbyw")
    public suspend fun status(`value`: Either<String, ConnectionStatus>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.status = mapped
    }

    /**
     * @param value The private link service connection status.
     */
    @JvmName("rkklqshpupjbevdl")
    public fun status(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ConnectionStatus>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.status = mapped
    }

    /**
     * @param value The private link service connection status.
     */
    @JvmName("nafgubwrxdyimacm")
    public fun status(`value`: ConnectionStatus) {
        val toBeMapped = Either.ofRight<String, ConnectionStatus>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.status = mapped
    }

    internal fun build(): PrivateLinkServiceConnectionStateArgs =
        PrivateLinkServiceConnectionStateArgs(
            actionsRequired = actionsRequired,
            description = description,
            status = status,
        )
}
