@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerregistry.kotlin.inputs

import com.pulumi.azurenative.containerregistry.inputs.RetentionPolicyArgs.builder
import com.pulumi.azurenative.containerregistry.kotlin.enums.PolicyStatus
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The retention policy for a container registry.
 * @property days The number of days to retain an untagged manifest after which it gets purged.
 * @property status The value that indicates whether the policy is enabled or not.
 */
public data class RetentionPolicyArgs(
    public val days: Output<Int>? = null,
    public val status: Output<Either<String, PolicyStatus>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.containerregistry.inputs.RetentionPolicyArgs> {
    override fun toJava(): com.pulumi.azurenative.containerregistry.inputs.RetentionPolicyArgs =
        com.pulumi.azurenative.containerregistry.inputs.RetentionPolicyArgs.builder()
            .days(days?.applyValue({ args0 -> args0 }))
            .status(
                status?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [RetentionPolicyArgs].
 */
@PulumiTagMarker
public class RetentionPolicyArgsBuilder internal constructor() {
    private var days: Output<Int>? = null

    private var status: Output<Either<String, PolicyStatus>>? = null

    /**
     * @param value The number of days to retain an untagged manifest after which it gets purged.
     */
    @JvmName("txbhvpkhnjntssit")
    public suspend fun days(`value`: Output<Int>) {
        this.days = value
    }

    /**
     * @param value The value that indicates whether the policy is enabled or not.
     */
    @JvmName("shygrawyvfgtcdxb")
    public suspend fun status(`value`: Output<Either<String, PolicyStatus>>) {
        this.status = value
    }

    /**
     * @param value The number of days to retain an untagged manifest after which it gets purged.
     */
    @JvmName("fvudajcieivfaymm")
    public suspend fun days(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.days = mapped
    }

    /**
     * @param value The value that indicates whether the policy is enabled or not.
     */
    @JvmName("ybpkuvwqmmgenlaw")
    public suspend fun status(`value`: Either<String, PolicyStatus>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.status = mapped
    }

    /**
     * @param value The value that indicates whether the policy is enabled or not.
     */
    @JvmName("mdmerlgeypxlqkvb")
    public fun status(`value`: String) {
        val toBeMapped = Either.ofLeft<String, PolicyStatus>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.status = mapped
    }

    /**
     * @param value The value that indicates whether the policy is enabled or not.
     */
    @JvmName("cedukjcqrynymauk")
    public fun status(`value`: PolicyStatus) {
        val toBeMapped = Either.ofRight<String, PolicyStatus>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.status = mapped
    }

    internal fun build(): RetentionPolicyArgs = RetentionPolicyArgs(
        days = days,
        status = status,
    )
}
