@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerregistry.kotlin.inputs

import com.pulumi.azurenative.containerregistry.inputs.TokenCertificateArgs.builder
import com.pulumi.azurenative.containerregistry.kotlin.enums.TokenCertificateName
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The properties of a certificate used for authenticating a token.
 * @property encodedPemCertificate Base 64 encoded string of the public certificate1 in PEM format that will be used for authenticating the token.
 * @property expiry The expiry datetime of the certificate.
 * @property name
 * @property thumbprint The thumbprint of the certificate.
 */
public data class TokenCertificateArgs(
    public val encodedPemCertificate: Output<String>? = null,
    public val expiry: Output<String>? = null,
    public val name: Output<Either<String, TokenCertificateName>>? = null,
    public val thumbprint: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.containerregistry.inputs.TokenCertificateArgs> {
    override fun toJava(): com.pulumi.azurenative.containerregistry.inputs.TokenCertificateArgs =
        com.pulumi.azurenative.containerregistry.inputs.TokenCertificateArgs.builder()
            .encodedPemCertificate(encodedPemCertificate?.applyValue({ args0 -> args0 }))
            .expiry(expiry?.applyValue({ args0 -> args0 }))
            .name(
                name?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .thumbprint(thumbprint?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [TokenCertificateArgs].
 */
@PulumiTagMarker
public class TokenCertificateArgsBuilder internal constructor() {
    private var encodedPemCertificate: Output<String>? = null

    private var expiry: Output<String>? = null

    private var name: Output<Either<String, TokenCertificateName>>? = null

    private var thumbprint: Output<String>? = null

    /**
     * @param value Base 64 encoded string of the public certificate1 in PEM format that will be used for authenticating the token.
     */
    @JvmName("stmncgkmbsqwrffy")
    public suspend fun encodedPemCertificate(`value`: Output<String>) {
        this.encodedPemCertificate = value
    }

    /**
     * @param value The expiry datetime of the certificate.
     */
    @JvmName("ufernkpcvwgcucow")
    public suspend fun expiry(`value`: Output<String>) {
        this.expiry = value
    }

    /**
     * @param value
     */
    @JvmName("ofpomlouhxnaagiu")
    public suspend fun name(`value`: Output<Either<String, TokenCertificateName>>) {
        this.name = value
    }

    /**
     * @param value The thumbprint of the certificate.
     */
    @JvmName("utdggkttdreysmwq")
    public suspend fun thumbprint(`value`: Output<String>) {
        this.thumbprint = value
    }

    /**
     * @param value Base 64 encoded string of the public certificate1 in PEM format that will be used for authenticating the token.
     */
    @JvmName("yfrsldahphepcrek")
    public suspend fun encodedPemCertificate(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.encodedPemCertificate = mapped
    }

    /**
     * @param value The expiry datetime of the certificate.
     */
    @JvmName("yywlqpjghxkwvhfr")
    public suspend fun expiry(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.expiry = mapped
    }

    /**
     * @param value
     */
    @JvmName("gqjdlakennleltoa")
    public suspend fun name(`value`: Either<String, TokenCertificateName>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value
     */
    @JvmName("bjwmaacepraavkqi")
    public fun name(`value`: String) {
        val toBeMapped = Either.ofLeft<String, TokenCertificateName>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value
     */
    @JvmName("uwtlxkhxgkbvofnc")
    public fun name(`value`: TokenCertificateName) {
        val toBeMapped = Either.ofRight<String, TokenCertificateName>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The thumbprint of the certificate.
     */
    @JvmName("lxvksdsufjbhrmsi")
    public suspend fun thumbprint(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.thumbprint = mapped
    }

    internal fun build(): TokenCertificateArgs = TokenCertificateArgs(
        encodedPemCertificate = encodedPemCertificate,
        expiry = expiry,
        name = name,
        thumbprint = thumbprint,
    )
}
