@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerregistry.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * The Docker build step.
 * @property arguments The collection of override arguments to be used when executing this build step.
 * @property baseImageDependencies List of base image dependencies for a step.
 * @property contextAccessToken The token (git PAT or SAS token of storage account blob) associated with the context for a step.
 * @property contextPath The URL(absolute or relative) of the source context for the task step.
 * @property dockerFilePath The Docker file path relative to the source context.
 * @property imageNames The fully qualified image names including the repository and tag.
 * @property isPushEnabled The value of this property indicates whether the image built should be pushed to the registry or not.
 * @property noCache The value of this property indicates whether the image cache is enabled or not.
 * @property target The name of the target build stage for the docker build.
 * @property type The type of the step.
 * Expected value is 'Docker'.
 */
public data class DockerBuildStepResponse(
    public val arguments: List<ArgumentResponse>? = null,
    public val baseImageDependencies: List<BaseImageDependencyResponse>,
    public val contextAccessToken: String? = null,
    public val contextPath: String? = null,
    public val dockerFilePath: String,
    public val imageNames: List<String>? = null,
    public val isPushEnabled: Boolean? = null,
    public val noCache: Boolean? = null,
    public val target: String? = null,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.containerregistry.outputs.DockerBuildStepResponse):
            DockerBuildStepResponse = DockerBuildStepResponse(
            arguments = javaType.arguments().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.containerregistry.kotlin.outputs.ArgumentResponse.Companion.toKotlin(args0)
                })
            }),
            baseImageDependencies = javaType.baseImageDependencies().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.containerregistry.kotlin.outputs.BaseImageDependencyResponse.Companion.toKotlin(args0)
                })
            }),
            contextAccessToken = javaType.contextAccessToken().map({ args0 -> args0 }).orElse(null),
            contextPath = javaType.contextPath().map({ args0 -> args0 }).orElse(null),
            dockerFilePath = javaType.dockerFilePath(),
            imageNames = javaType.imageNames().map({ args0 -> args0 }),
            isPushEnabled = javaType.isPushEnabled().map({ args0 -> args0 }).orElse(null),
            noCache = javaType.noCache().map({ args0 -> args0 }).orElse(null),
            target = javaType.target().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
        )
    }
}
