@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerregistry.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * The parameters for a quick task run request.
 * @property agentConfiguration The machine configuration of the run agent.
 * @property agentPoolName The dedicated agent pool for the run.
 * @property credentials The properties that describes a set of credentials that will be used when this run is invoked.
 * @property encodedTaskContent Base64 encoded value of the template/definition file content.
 * @property encodedValuesContent Base64 encoded value of the parameters/values file content.
 * @property isArchiveEnabled The value that indicates whether archiving is enabled for the run or not.
 * @property logTemplate The template that describes the repository and tag information for run log artifact.
 * @property platform The platform properties against which the run has to happen.
 * @property sourceLocation The URL(absolute or relative) of the source context. It can be an URL to a tar or git repository.
 * If it is relative URL, the relative path should be obtained from calling listBuildSourceUploadUrl API.
 * @property timeout Run timeout in seconds.
 * @property type The type of the run request.
 * Expected value is 'EncodedTaskRunRequest'.
 * @property values The collection of overridable values that can be passed when running a task.
 */
public data class EncodedTaskRunRequestResponse(
    public val agentConfiguration: AgentPropertiesResponse? = null,
    public val agentPoolName: String? = null,
    public val credentials: CredentialsResponse? = null,
    public val encodedTaskContent: String,
    public val encodedValuesContent: String? = null,
    public val isArchiveEnabled: Boolean? = null,
    public val logTemplate: String? = null,
    public val platform: PlatformPropertiesResponse,
    public val sourceLocation: String? = null,
    public val timeout: Int? = null,
    public val type: String,
    public val values: List<SetValueResponse>? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.containerregistry.outputs.EncodedTaskRunRequestResponse):
            EncodedTaskRunRequestResponse = EncodedTaskRunRequestResponse(
            agentConfiguration = javaType.agentConfiguration().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.containerregistry.kotlin.outputs.AgentPropertiesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            agentPoolName = javaType.agentPoolName().map({ args0 -> args0 }).orElse(null),
            credentials = javaType.credentials().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.containerregistry.kotlin.outputs.CredentialsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            encodedTaskContent = javaType.encodedTaskContent(),
            encodedValuesContent = javaType.encodedValuesContent().map({ args0 -> args0 }).orElse(null),
            isArchiveEnabled = javaType.isArchiveEnabled().map({ args0 -> args0 }).orElse(null),
            logTemplate = javaType.logTemplate().map({ args0 -> args0 }).orElse(null),
            platform = javaType.platform().let({ args0 ->
                com.pulumi.azurenative.containerregistry.kotlin.outputs.PlatformPropertiesResponse.Companion.toKotlin(args0)
            }),
            sourceLocation = javaType.sourceLocation().map({ args0 -> args0 }).orElse(null),
            timeout = javaType.timeout().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
            values = javaType.values().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.containerregistry.kotlin.outputs.SetValueResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
