@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerregistry.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * An object that represents a webhook for a container registry.
 * @property actions The list of actions that trigger the webhook to post notifications.
 * @property id The resource ID.
 * @property location The location of the resource. This cannot be changed after the resource is created.
 * @property name The name of the resource.
 * @property provisioningState The provisioning state of the webhook at the time the operation was called.
 * @property scope The scope of repositories where the event can be triggered. For example, 'foo:*' means events for all tags under repository 'foo'. 'foo:bar' means events for 'foo:bar' only. 'foo' is equivalent to 'foo:latest'. Empty means all events.
 * @property status The status of the webhook at the time the operation was called.
 * @property systemData Metadata pertaining to creation and last modification of the resource.
 * @property tags The tags of the resource.
 * @property type The type of the resource.
 */
public data class GetWebhookResult(
    public val actions: List<String>,
    public val id: String,
    public val location: String,
    public val name: String,
    public val provisioningState: String,
    public val scope: String? = null,
    public val status: String? = null,
    public val systemData: SystemDataResponse,
    public val tags: Map<String, String>? = null,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.containerregistry.outputs.GetWebhookResult):
            GetWebhookResult = GetWebhookResult(
            actions = javaType.actions().map({ args0 -> args0 }),
            id = javaType.id(),
            location = javaType.location(),
            name = javaType.name(),
            provisioningState = javaType.provisioningState(),
            scope = javaType.scope().map({ args0 -> args0 }).orElse(null),
            status = javaType.status().map({ args0 -> args0 }).orElse(null),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.containerregistry.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
        )
    }
}
