@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerregistry.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * Managed identity for the resource.
 * @property principalId The principal ID of resource identity.
 * @property tenantId The tenant ID of resource.
 * @property type The identity type.
 * @property userAssignedIdentities The list of user identities associated with the resource. The user identity
 * dictionary key references will be ARM resource ids in the form:
 * '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/
 *     providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.
 */
public data class IdentityPropertiesResponse(
    public val principalId: String? = null,
    public val tenantId: String? = null,
    public val type: String? = null,
    public val userAssignedIdentities: Map<String, UserIdentityPropertiesResponse>? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.containerregistry.outputs.IdentityPropertiesResponse):
            IdentityPropertiesResponse = IdentityPropertiesResponse(
            principalId = javaType.principalId().map({ args0 -> args0 }).orElse(null),
            tenantId = javaType.tenantId().map({ args0 -> args0 }).orElse(null),
            type = javaType.type().map({ args0 -> args0 }).orElse(null),
            userAssignedIdentities = javaType.userAssignedIdentities().map({ args0 ->
                args0.key.to(
                    args0.value.let({ args0 ->
                        com.pulumi.azurenative.containerregistry.kotlin.outputs.UserIdentityPropertiesResponse.Companion.toKotlin(args0)
                    }),
                )
            }).toMap(),
        )
    }
}
