@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerregistry.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * The image update trigger that caused a build.
 * @property id The unique ID of the trigger.
 * @property images The list of image updates that caused the build.
 * @property timestamp The timestamp when the image update happened.
 */
public data class ImageUpdateTriggerResponse(
    public val id: String? = null,
    public val images: List<ImageDescriptorResponse>? = null,
    public val timestamp: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.containerregistry.outputs.ImageUpdateTriggerResponse):
            ImageUpdateTriggerResponse = ImageUpdateTriggerResponse(
            id = javaType.id().map({ args0 -> args0 }).orElse(null),
            images = javaType.images().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.containerregistry.kotlin.outputs.ImageDescriptorResponse.Companion.toKotlin(args0)
                })
            }),
            timestamp = javaType.timestamp().map({ args0 -> args0 }).orElse(null),
        )
    }
}
