@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerregistry.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * The network rule set for a container registry.
 * @property defaultAction The default action of allow or deny when no other rules match.
 * @property ipRules The IP ACL rules.
 */
public data class NetworkRuleSetResponse(
    public val defaultAction: String,
    public val ipRules: List<IPRuleResponse>? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.containerregistry.outputs.NetworkRuleSetResponse):
            NetworkRuleSetResponse = NetworkRuleSetResponse(
            defaultAction = javaType.defaultAction(),
            ipRules = javaType.ipRules().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.containerregistry.kotlin.outputs.IPRuleResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
