@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerregistry.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Describes the credential parameters for accessing the source registry.
 * @property loginMode The authentication mode which determines the source registry login scope. The credentials for the source registry
 * will be generated using the given scope. These credentials will be used to login to
 * the source registry during the run.
 */
public data class SourceRegistryCredentialsResponse(
    public val loginMode: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.containerregistry.outputs.SourceRegistryCredentialsResponse):
            SourceRegistryCredentialsResponse = SourceRegistryCredentialsResponse(
            loginMode = javaType.loginMode().map({ args0 -> args0 }).orElse(null),
        )
    }
}
