@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerregistry.kotlin.outputs

import kotlin.Double
import kotlin.String
import kotlin.Suppress

/**
 * The target of the event.
 * @property digest The digest of the content, as defined by the Registry V2 HTTP API Specification.
 * @property length The number of bytes of the content. Same as Size field.
 * @property mediaType The MIME type of the referenced object.
 * @property name The name of the artifact.
 * @property repository The repository name.
 * @property size The number of bytes of the content. Same as Length field.
 * @property tag The tag name.
 * @property url The direct URL to the content.
 * @property version The version of the artifact.
 */
public data class TargetResponse(
    public val digest: String? = null,
    public val length: Double? = null,
    public val mediaType: String? = null,
    public val name: String? = null,
    public val repository: String? = null,
    public val size: Double? = null,
    public val tag: String? = null,
    public val url: String? = null,
    public val version: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.containerregistry.outputs.TargetResponse):
            TargetResponse = TargetResponse(
            digest = javaType.digest().map({ args0 -> args0 }).orElse(null),
            length = javaType.length().map({ args0 -> args0 }).orElse(null),
            mediaType = javaType.mediaType().map({ args0 -> args0 }).orElse(null),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            repository = javaType.repository().map({ args0 -> args0 }).orElse(null),
            size = javaType.size().map({ args0 -> args0 }).orElse(null),
            tag = javaType.tag().map({ args0 -> args0 }).orElse(null),
            url = javaType.url().map({ args0 -> args0 }).orElse(null),
            version = javaType.version().map({ args0 -> args0 }).orElse(null),
        )
    }
}
